/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mobile.device.wurfl;

import java.util.List;
import net.sourceforge.wurfl.core.DefaultDeviceProvider;
import net.sourceforge.wurfl.core.DefaultWURFLManager;
import net.sourceforge.wurfl.core.DefaultWURFLService;
import net.sourceforge.wurfl.core.DeviceProvider;
import net.sourceforge.wurfl.core.WURFLManager;
import net.sourceforge.wurfl.core.WURFLService;
import net.sourceforge.wurfl.core.handlers.matchers.MatcherManager;
import net.sourceforge.wurfl.core.resource.DefaultWURFLModel;
import net.sourceforge.wurfl.core.resource.SpringXMLResource;
import net.sourceforge.wurfl.core.resource.WURFLModel;
import net.sourceforge.wurfl.core.resource.WURFLResource;
import net.sourceforge.wurfl.core.resource.WURFLResources;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WurflManagerFactoryBean
implements FactoryBean<WURFLManager>,
InitializingBean {
    private final Resource rootLocation;
    private List<? extends Resource> patchLocations;
    private WURFLManager manager;

    public WurflManagerFactoryBean(Resource rootLocation) {
        Assert.notNull((Object)rootLocation, (String)"The rootResource property cannot be null");
        this.rootLocation = rootLocation;
    }

    public void setPatchLocations(List<? extends Resource> patchLocations) {
        this.patchLocations = patchLocations;
    }

    public void afterPropertiesSet() throws Exception {
        this.manager = this.createWURFLManager();
    }

    public Class<?> getObjectType() {
        return WURFLManager.class;
    }

    public WURFLManager getObject() throws Exception {
        return this.manager;
    }

    public boolean isSingleton() {
        return true;
    }

    private WURFLManager createWURFLManager() {
        DefaultWURFLModel model = new DefaultWURFLModel((WURFLResource)this.getRoot(), this.getPatches());
        MatcherManager matcherManager = new MatcherManager((WURFLModel)model);
        DefaultDeviceProvider deviceProvider = new DefaultDeviceProvider((WURFLModel)model);
        DefaultWURFLService service = new DefaultWURFLService(matcherManager, (DeviceProvider)deviceProvider);
        return new DefaultWURFLManager((WURFLService)service);
    }

    private SpringXMLResource getRoot() {
        return new SpringXMLResource(this.rootLocation);
    }

    private WURFLResources getPatches() {
        if (this.patchLocations == null) {
            return null;
        }
        WURFLResources patches = new WURFLResources();
        for (Resource resource : this.patchLocations) {
            patches.add((WURFLResource)new SpringXMLResource(resource));
        }
        return patches;
    }
}

