/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mobile.device;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.mobile.device.Device;
import org.springframework.mobile.device.DeviceResolver;
import org.springframework.mobile.device.LiteDevice;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiteDeviceResolver
implements DeviceResolver {
    private final List<String> userAgentPrefixes = new ArrayList<String>();
    private final List<String> userAgentKeywords = new ArrayList<String>();
    private static final String[] KNOWN_USER_AGENT_PREFIXES = new String[]{"w3c ", "w3c-", "acs-", "alav", "alca", "amoi", "audi", "avan", "benq", "bird", "blac", "blaz", "brew", "cell", "cldc", "cmd-", "dang", "doco", "eric", "hipt", "htc_", "inno", "ipaq", "ipod", "jigs", "kddi", "keji", "leno", "lg-c", "lg-d", "lg-g", "lge-", "lg/u", "maui", "maxo", "midp", "mits", "mmef", "mobi", "mot-", "moto", "mwbp", "nec-", "newt", "noki", "palm", "pana", "pant", "phil", "play", "port", "prox", "qwap", "sage", "sams", "sany", "sch-", "sec-", "send", "seri", "sgh-", "shar", "sie-", "siem", "smal", "smar", "sony", "sph-", "symb", "t-mo", "teli", "tim-", "tosh", "tsm-", "upg1", "upsi", "vk-v", "voda", "wap-", "wapa", "wapi", "wapp", "wapr", "webc", "winw", "winw", "xda ", "xda-"};
    private static final String[] KNOWN_USER_AGENT_KEYWORDS = new String[]{"android", "blackberry", "hiptop", "ipod", "lge vx", "midp", "maemo", "mmp", "netfront", "nintendo DS", "novarra", "openweb", "opera mobi", "opera mini", "palm", "psp", "phone", "smartphone", "symbian", "up.browser", "up.link", "wap", "windows ce"};

    public LiteDeviceResolver() {
        this.init();
    }

    @Override
    public Device resolveDevice(HttpServletRequest request) {
        String prefix;
        if (request.getHeader("x-wap-profile") != null || request.getHeader("Profile") != null) {
            return LiteDevice.MOBILE_INSTANCE;
        }
        String userAgent = request.getHeader("User-Agent");
        if (userAgent != null && userAgent.length() >= 4 && this.userAgentPrefixes.contains(prefix = userAgent.substring(0, 4).toLowerCase())) {
            return LiteDevice.MOBILE_INSTANCE;
        }
        String accept = request.getHeader("Accept");
        if (accept != null && accept.contains("wap")) {
            return LiteDevice.MOBILE_INSTANCE;
        }
        if (userAgent != null) {
            userAgent = userAgent.toLowerCase();
            for (String keyword : this.userAgentKeywords) {
                if (!userAgent.contains(keyword)) continue;
                return LiteDevice.MOBILE_INSTANCE;
            }
        }
        Enumeration headers = request.getHeaderNames();
        while (headers.hasMoreElements()) {
            String header = (String)headers.nextElement();
            if (!header.contains("OperaMini")) continue;
            return LiteDevice.MOBILE_INSTANCE;
        }
        return this.resolveFallback(request);
    }

    protected List<String> getUserAgentPrefixes() {
        return this.userAgentPrefixes;
    }

    protected List<String> getUserAgentKeywords() {
        return this.userAgentKeywords;
    }

    protected void init() {
        this.getUserAgentPrefixes().addAll(Arrays.asList(KNOWN_USER_AGENT_PREFIXES));
        this.getUserAgentKeywords().addAll(Arrays.asList(KNOWN_USER_AGENT_KEYWORDS));
    }

    protected Device resolveFallback(HttpServletRequest request) {
        return LiteDevice.NOT_MOBILE_INSTANCE;
    }
}

