/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.web;

import java.util.Arrays;
import org.springframework.http.HttpStatus;
import org.springframework.metrics.instrument.Tag;
import org.springframework.metrics.instrument.TagFormatter;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.server.ServerWebExchange;

public class WebfluxTagConfigurer {
    private final TagFormatter tagFormatter;

    public WebfluxTagConfigurer(TagFormatter tagFormatter) {
        this.tagFormatter = tagFormatter;
    }

    Iterable<Tag> httpRequestTags(ServerWebExchange exchange, Throwable exception) {
        return Arrays.asList(this.method(exchange), this.uri(exchange), this.exception(exception), this.status(exchange));
    }

    public Tag uri(ServerWebExchange exchange) {
        String rawUri = exchange.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE).orElse(null);
        if (!StringUtils.hasText((String)rawUri)) {
            rawUri = "/";
        }
        return Tag.of("uri", (rawUri = this.tagFormatter.formatTagValue(rawUri.substring(1))).isEmpty() ? "root" : rawUri);
    }

    public Tag method(ServerWebExchange exchange) {
        return Tag.of("method", exchange.getRequest().getMethod().toString());
    }

    public Tag status(ServerWebExchange exchange) {
        HttpStatus status = exchange.getResponse().getStatusCode();
        if (status == null) {
            status = HttpStatus.OK;
        }
        return Tag.of("status", status.toString());
    }

    public Tag exception(Throwable exception) {
        if (exception != null) {
            return Tag.of("exception", exception.getClass().getSimpleName());
        }
        return Tag.of("exception", "None");
    }
}

