/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.stats.hist;

import java.util.concurrent.TimeUnit;
import org.springframework.metrics.instrument.internal.TimeUtils;
import org.springframework.metrics.instrument.stats.hist.BucketFunction;
import org.springframework.metrics.instrument.stats.hist.NormalHistogram;

public class TimeScaleNormalHistogram
extends NormalHistogram<Double> {
    private final TimeUnit timeScale;

    public TimeScaleNormalHistogram(BucketFunction<? extends Double> f, TimeUnit timeScale) {
        super(f);
        this.timeScale = timeScale;
    }

    public TimeScaleNormalHistogram shiftScale(TimeUnit targetUnit) {
        if (targetUnit.equals((Object)this.timeScale)) {
            return this;
        }
        return new TimeScaleNormalHistogram(new ScaledBucketFunction(this.timeScale, targetUnit), targetUnit);
    }

    class ScaledBucketFunction
    implements BucketFunction<Double> {
        private final TimeUnit targetUnit;
        private final TimeUnit sourceUnit;

        ScaledBucketFunction(TimeUnit sourceUnit, TimeUnit targetUnit) {
            this.sourceUnit = sourceUnit;
            this.targetUnit = targetUnit;
        }

        @Override
        public Double bucket(double d) {
            return TimeUtils.convert((Double)TimeScaleNormalHistogram.this.f.bucket(TimeUtils.convert(d, this.targetUnit, this.sourceUnit)), this.sourceUnit, this.targetUnit);
        }
    }
}

