/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.simple;

import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.metrics.instrument.Clock;
import org.springframework.metrics.instrument.LongTaskTimer;
import org.springframework.metrics.instrument.Measurement;
import org.springframework.metrics.instrument.Tag;
import org.springframework.metrics.instrument.internal.MeterId;
import org.springframework.metrics.instrument.simple.AbstractSimpleMeter;
import org.springframework.metrics.instrument.simple.SimpleUtils;

public class SimpleLongTaskTimer
extends AbstractSimpleMeter
implements LongTaskTimer {
    private final ConcurrentMap<Long, Long> tasks = new ConcurrentHashMap<Long, Long>();
    private final AtomicLong nextTask = new AtomicLong(0L);
    private final Clock clock;

    SimpleLongTaskTimer(MeterId id, Clock clock) {
        super(id);
        this.clock = clock;
    }

    @Override
    public long start() {
        long task = this.nextTask.getAndIncrement();
        this.tasks.put(task, this.clock.monotonicTime());
        return task;
    }

    @Override
    public long stop(long task) {
        Long startTime = (Long)this.tasks.get(task);
        if (startTime != null) {
            this.tasks.remove(task);
            return this.clock.monotonicTime() - startTime;
        }
        return -1L;
    }

    @Override
    public long duration(long task) {
        Long startTime = (Long)this.tasks.get(task);
        return startTime != null ? this.clock.monotonicTime() - startTime : -1L;
    }

    @Override
    public long duration() {
        long now = this.clock.monotonicTime();
        long sum = 0L;
        Iterator iterator = this.tasks.values().iterator();
        while (iterator.hasNext()) {
            long startTime = (Long)iterator.next();
            sum += now - startTime;
        }
        return sum;
    }

    @Override
    public int activeTasks() {
        return this.tasks.size();
    }

    @Override
    public Iterable<Measurement> measure() {
        return Arrays.asList(this.id.withTags(SimpleUtils.typeTag(this.getType()), Tag.of("statistic", "activeTasks")).measurement(this.activeTasks()), this.id.withTags(SimpleUtils.typeTag(this.getType()), Tag.of("statistic", "duration")).measurement(this.duration()));
    }
}

