/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.simple;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.function.ToDoubleFunction;
import org.springframework.metrics.instrument.Gauge;
import org.springframework.metrics.instrument.Measurement;
import org.springframework.metrics.instrument.internal.MeterId;
import org.springframework.metrics.instrument.simple.AbstractSimpleMeter;
import org.springframework.metrics.instrument.simple.SimpleUtils;

public class SimpleGauge<T>
extends AbstractSimpleMeter
implements Gauge {
    private final WeakReference<T> ref;
    private final ToDoubleFunction<T> value;

    SimpleGauge(MeterId id, T obj, ToDoubleFunction<T> value) {
        super(id);
        this.ref = new WeakReference<T>(obj);
        this.value = value;
    }

    @Override
    public double value() {
        return this.value.applyAsDouble(this.ref.get());
    }

    @Override
    public Iterable<Measurement> measure() {
        return Collections.singletonList(this.id.withTags(SimpleUtils.typeTag(this.getType())).measurement(this.value()));
    }
}

