/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.scheduling;

import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.metrics.annotation.Timed;
import org.springframework.metrics.instrument.LongTaskTimer;
import org.springframework.metrics.instrument.MeterRegistry;
import org.springframework.metrics.instrument.Timer;
import org.springframework.metrics.instrument.internal.AnnotationUtils;
import org.springframework.metrics.instrument.stats.quantile.WindowSketchQuantiles;

@Aspect
public class MetricsSchedulingAspect {
    private static final Log logger = LogFactory.getLog(MetricsSchedulingAspect.class);
    private final MeterRegistry registry;

    public MetricsSchedulingAspect(MeterRegistry registry) {
        this.registry = registry;
    }

    @Around(value="execution (@org.springframework.scheduling.annotation.Scheduled  * *.*(..))")
    public Object timeScheduledOperation(ProceedingJoinPoint pjp) throws Throwable {
        Method method = ((MethodSignature)pjp.getSignature()).getMethod();
        String signature = pjp.getSignature().toShortString();
        if (method.getDeclaringClass().isInterface()) {
            try {
                method = pjp.getTarget().getClass().getDeclaredMethod(pjp.getSignature().getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException | SecurityException e) {
                logger.warn((Object)("Unable to perform metrics timing on " + signature), (Throwable)e);
                return pjp.proceed();
            }
        }
        Timer shortTaskTimer = null;
        LongTaskTimer longTaskTimer = null;
        for (Timed timed : (Timed[])AnnotationUtils.findTimed(method).toArray(Timed[]::new)) {
            if (timed.longTask()) {
                longTaskTimer = this.registry.longTaskTimer(timed.value(), timed.extraTags());
                continue;
            }
            Timer.Builder timerBuilder = this.registry.timerBuilder(timed.value()).tags(timed.extraTags());
            if (timed.quantiles().length > 0) {
                timerBuilder = timerBuilder.quantiles(WindowSketchQuantiles.quantiles(timed.quantiles()).create());
            }
            shortTaskTimer = timerBuilder.create();
        }
        if (shortTaskTimer != null && longTaskTimer != null) {
            Timer finalTimer = shortTaskTimer;
            return this.recordThrowable(longTaskTimer, () -> this.recordThrowable(finalTimer, () -> ((ProceedingJoinPoint)pjp).proceed()));
        }
        if (shortTaskTimer != null) {
            return this.recordThrowable(shortTaskTimer, () -> ((ProceedingJoinPoint)pjp).proceed());
        }
        if (longTaskTimer != null) {
            return this.recordThrowable(longTaskTimer, () -> ((ProceedingJoinPoint)pjp).proceed());
        }
        return pjp.proceed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object recordThrowable(LongTaskTimer timer, ThrowableCallable f) throws Throwable {
        long id = timer.start();
        try {
            Object object = f.call();
            return object;
        }
        finally {
            timer.stop(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object recordThrowable(Timer timer, ThrowableCallable f) throws Throwable {
        long start = this.registry.getClock().monotonicTime();
        try {
            Object object = f.call();
            return object;
        }
        finally {
            timer.record(this.registry.getClock().monotonicTime() - start, TimeUnit.NANOSECONDS);
        }
    }

    private static interface ThrowableCallable {
        public Object call() throws Throwable;
    }
}

