/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.scheduling;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.metrics.instrument.Measurement;
import org.springframework.metrics.instrument.Meter;
import org.springframework.metrics.instrument.MeterRegistry;
import org.springframework.metrics.instrument.Meters;
import org.springframework.metrics.instrument.Tag;
import org.springframework.metrics.instrument.binder.MeterBinder;

public class ExecutorServiceMetrics
implements MeterBinder {
    private final ExecutorService executorService;
    private final String name;
    private final Iterable<Tag> tags;

    public ExecutorServiceMetrics(ExecutorService executorService, String name, Iterable<Tag> tags) {
        this.name = name;
        this.tags = tags;
        this.executorService = executorService;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        if (this.executorService == null) {
            return;
        }
        String className = this.executorService.getClass().getName();
        if (this.executorService instanceof ThreadPoolExecutor) {
            this.monitor(registry, (ThreadPoolExecutor)this.executorService);
        } else if (className.equals("java.util.concurrent.Executors$DelegatedScheduledExecutorService")) {
            this.monitor(registry, this.unwrapThreadPoolExecutor(this.executorService, this.executorService.getClass()));
        } else if (className.equals("java.util.concurrent.Executors$FinalizableDelegatedExecutorService")) {
            this.monitor(registry, this.unwrapThreadPoolExecutor(this.executorService, this.executorService.getClass().getSuperclass()));
        } else if (this.executorService instanceof ForkJoinPool) {
            this.monitor(registry, (ForkJoinPool)this.executorService);
        }
    }

    private ThreadPoolExecutor unwrapThreadPoolExecutor(ExecutorService executor, Class<?> wrapper) {
        try {
            Field e = wrapper.getDeclaredField("e");
            e.setAccessible(true);
            return (ThreadPoolExecutor)e.get(this.executorService);
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            return null;
        }
    }

    private void monitor(MeterRegistry registry, ThreadPoolExecutor tp) {
        if (tp == null) {
            return;
        }
        registry.register(Meters.build(this.name).type(Meter.Type.Counter).tags(this.tags).create(tp, (n, tpRef) -> Arrays.asList(new Measurement((String)n, Collections.singletonList(Tag.of("lifecycle", "scheduled")), tpRef.getTaskCount()), new Measurement((String)n, Collections.singletonList(Tag.of("lifecycle", "completed")), tpRef.getCompletedTaskCount()), new Measurement((String)n, Collections.singletonList(Tag.of("lifecycle", "active")), tpRef.getActiveCount()))));
        registry.gauge(this.name + "_queue_size", this.tags, tp, tpRef -> tpRef.getQueue().size());
        registry.gauge(this.name + "_pool_size", this.tags, tp, ThreadPoolExecutor::getPoolSize);
    }

    private void monitor(MeterRegistry registry, ForkJoinPool fj) {
        registry.gauge(this.name + "_active", fj, ForkJoinPool::getActiveThreadCount);
        registry.gauge(this.name + "_queued_tasks", fj, ForkJoinPool::getQueuedTaskCount);
        registry.gauge(this.name + "_running_threads", fj, ForkJoinPool::getRunningThreadCount);
        registry.gauge(this.name + "_steal_count", fj, ForkJoinPool::getStealCount);
    }
}

