/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.binder;

import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.util.Collections;
import java.util.List;
import org.springframework.metrics.instrument.MeterRegistry;
import org.springframework.metrics.instrument.Tag;
import org.springframework.metrics.instrument.binder.MeterBinder;

public class JvmMemoryMetrics
implements MeterBinder {
    @Override
    public void bindTo(MeterRegistry registry) {
        List<Tag> tags;
        for (BufferPoolMXBean bufferPoolBean : ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class)) {
            tags = Collections.singletonList(Tag.of("id", bufferPoolBean.getName()));
            registry.gauge("jvm_buffer_count", tags, bufferPoolBean, BufferPoolMXBean::getCount);
            registry.gauge("jvm_buffer_memory_used", tags, bufferPoolBean, BufferPoolMXBean::getMemoryUsed);
            registry.gauge("jvm_buffer_total_capacity", tags, bufferPoolBean, BufferPoolMXBean::getTotalCapacity);
        }
        for (MemoryPoolMXBean memoryPoolBean : ManagementFactory.getPlatformMXBeans(MemoryPoolMXBean.class)) {
            tags = Collections.singletonList(Tag.of("id", memoryPoolBean.getName()));
            registry.gauge("jvm_memory_used", tags, memoryPoolBean, mem -> mem.getUsage().getUsed());
            registry.gauge("jvm_memory_committed", tags, memoryPoolBean, mem -> mem.getUsage().getCommitted());
            registry.gauge("jvm_memory_max", tags, memoryPoolBean, mem -> mem.getUsage().getMax());
        }
    }
}

