/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument.binder;

import java.util.Collection;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.jdbc.metadata.DataSourcePoolMetadata;
import org.springframework.boot.autoconfigure.jdbc.metadata.DataSourcePoolMetadataProvider;
import org.springframework.boot.autoconfigure.jdbc.metadata.DataSourcePoolMetadataProviders;
import org.springframework.metrics.instrument.MeterRegistry;
import org.springframework.metrics.instrument.Tag;
import org.springframework.metrics.instrument.binder.MeterBinder;

public class DataSourceMetrics
implements MeterBinder {
    private final DataSource dataSource;
    private final Collection<DataSourcePoolMetadataProvider> metadataProviders;
    private final String name;
    private final Iterable<Tag> tags;

    public DataSourceMetrics(DataSource dataSource, Collection<DataSourcePoolMetadataProvider> metadataProviders, String name, Iterable<Tag> tags) {
        this.name = name;
        this.tags = tags;
        this.dataSource = dataSource;
        this.metadataProviders = metadataProviders;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        DataSourcePoolMetadataProviders provider = new DataSourcePoolMetadataProviders(this.metadataProviders);
        DataSourcePoolMetadata poolMetadata = provider.getDataSourcePoolMetadata(this.dataSource);
        if (poolMetadata != null) {
            if (poolMetadata.getActive() != null) {
                registry.gauge(this.name + "_active_connections", this.tags, poolMetadata, DataSourcePoolMetadata::getActive);
            }
            if (poolMetadata.getMax() != null) {
                registry.gauge(this.name + "_max_connections", this.tags, poolMetadata, DataSourcePoolMetadata::getMax);
            }
            if (poolMetadata.getMin() != null) {
                registry.gauge(this.name + "_min_connections", this.tags, poolMetadata, DataSourcePoolMetadata::getMin);
            }
        }
    }
}

