/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.instrument;

import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.springframework.metrics.instrument.Meter;

public interface LongTaskTimer
extends Meter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T> T recordCallable(Callable<T> f) throws Exception {
        long id = this.start();
        try {
            T t = f.call();
            return t;
        }
        finally {
            this.stop(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T> T record(Supplier<T> f) throws Exception {
        long id = this.start();
        try {
            T t = f.get();
            return t;
        }
        finally {
            this.stop(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void record(Consumer<Long> f) {
        long id = this.start();
        try {
            f.accept(id);
        }
        finally {
            this.stop(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void record(Runnable f) {
        long id = this.start();
        try {
            f.run();
        }
        finally {
            this.stop(id);
        }
    }

    public long start();

    public long stop(long var1);

    public long duration(long var1);

    public long duration();

    public int activeTasks();

    @Override
    default public Meter.Type getType() {
        return Meter.Type.LongTaskTimer;
    }
}

