/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.export.datadog;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.impl.StepLong;
import java.util.Collections;

public class DatadogCounter
implements Counter {
    private final Id id;
    private final StepLong value;

    DatadogCounter(Id id, Clock clock, long step) {
        this.id = id;
        this.value = new StepLong(0L, clock, step);
    }

    public Id id() {
        return this.id;
    }

    public boolean hasExpired() {
        return false;
    }

    public Iterable<Measurement> measure() {
        double rate = this.value.pollAsRate();
        Measurement m = new Measurement(this.id, this.value.timestamp(), rate);
        return Collections.singletonList(m);
    }

    public void increment() {
        this.value.getCurrent().incrementAndGet();
    }

    public void increment(long amount) {
        this.value.getCurrent().addAndGet(amount);
    }

    public long count() {
        return this.value.poll();
    }
}

