/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.metrics.boot;

import java.util.ArrayList;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.metrics.instrument.MeterRegistry;
import org.springframework.metrics.instrument.TagFormatter;
import org.springframework.metrics.instrument.web.MetricsRestTemplateInterceptor;
import org.springframework.metrics.instrument.web.RestTemplateTagConfigurer;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnClass(value={RestTemplate.class})
class InstrumentRestTemplateConfiguration {
    @Autowired(required=false)
    RestTemplateTagConfigurer tagConfigurer;

    InstrumentRestTemplateConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean(value={RestTemplateTagConfigurer.class})
    RestTemplateTagConfigurer restTemplateTagConfigurer(TagFormatter tagFormatter) {
        if (this.tagConfigurer != null) {
            return this.tagConfigurer;
        }
        this.tagConfigurer = new RestTemplateTagConfigurer(tagFormatter);
        return this.tagConfigurer;
    }

    @Bean
    MetricsRestTemplateInterceptor clientHttpRequestInterceptor(MeterRegistry meterRegistry, TagFormatter tagFormatter, Environment environment) {
        return new MetricsRestTemplateInterceptor(meterRegistry, this.restTemplateTagConfigurer(tagFormatter), environment.getProperty("spring.metrics.web.client_requests.name", "http_client_requests"));
    }

    @Bean
    static BeanPostProcessor restTemplateInterceptorPostProcessor() {
        return new MetricsInterceptorPostProcessor();
    }

    private static class MetricsInterceptorPostProcessor
    implements BeanPostProcessor,
    ApplicationContextAware {
        private ApplicationContext context;
        private MetricsRestTemplateInterceptor interceptor;

        private MetricsInterceptorPostProcessor() {
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) {
            return bean;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) {
            if (bean instanceof RestTemplate) {
                if (this.interceptor == null) {
                    this.interceptor = (MetricsRestTemplateInterceptor)this.context.getBean(MetricsRestTemplateInterceptor.class);
                }
                RestTemplate restTemplate = (RestTemplate)bean;
                ArrayList<MetricsRestTemplateInterceptor> interceptors = new ArrayList<MetricsRestTemplateInterceptor>();
                interceptors.add(this.interceptor);
                interceptors.addAll(restTemplate.getInterceptors());
                restTemplate.setInterceptors(interceptors);
            }
            return bean;
        }

        public void setApplicationContext(ApplicationContext context) throws BeansException {
            this.context = context;
        }
    }
}

