/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.control;

import java.lang.reflect.Method;
import javax.naming.NamingException;
import javax.naming.ldap.Control;
import org.springframework.ldap.control.AbstractFallbackRequestAndResponseControlDirContextProcessor;
import org.springframework.ldap.control.VirtualListViewResultsCookie;
import org.springframework.ldap.support.LdapUtils;
import org.springframework.util.ReflectionUtils;

public class VirtualListViewControlDirContextProcessor
extends AbstractFallbackRequestAndResponseControlDirContextProcessor {
    private static final String DEFAULT_REQUEST_CONTROL = "com.sun.jndi.ldap.ctl.VirtualListViewControl";
    private static final String DEFAULT_RESPONSE_CONTROL = "com.sun.jndi.ldap.ctl.VirtualListViewResponseControl";
    private static final boolean CRITICAL_CONTROL = true;
    private int pageSize;
    private VirtualListViewResultsCookie cookie;
    private int listSize;
    private int targetOffset;
    private NamingException exception;
    private boolean offsetPercentage;

    public VirtualListViewControlDirContextProcessor(int pageSize) {
        this(pageSize, 1, 0, null);
    }

    public VirtualListViewControlDirContextProcessor(int pageSize, int targetOffset, int listSize, VirtualListViewResultsCookie cookie) {
        this.pageSize = pageSize;
        this.targetOffset = targetOffset;
        this.listSize = listSize;
        this.cookie = cookie;
        this.defaultRequestControl = DEFAULT_REQUEST_CONTROL;
        this.defaultResponseControl = DEFAULT_RESPONSE_CONTROL;
        this.fallbackRequestControl = DEFAULT_REQUEST_CONTROL;
        this.fallbackResponseControl = DEFAULT_RESPONSE_CONTROL;
        this.loadControlClasses();
    }

    public VirtualListViewResultsCookie getCookie() {
        return this.cookie;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getListSize() {
        return this.listSize;
    }

    public NamingException getException() {
        return this.exception;
    }

    public int getTargetOffset() {
        return this.targetOffset;
    }

    public void setOffsetPercentage(boolean isPercentage) {
        this.offsetPercentage = isPercentage;
    }

    public boolean isOffsetPercentage() {
        return this.offsetPercentage;
    }

    public Control createRequestControl() {
        Control control = this.offsetPercentage ? super.createRequestControl(new Class[]{Integer.TYPE, Integer.TYPE, Boolean.TYPE}, new Object[]{this.targetOffset, this.pageSize, true}) : super.createRequestControl(new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE}, new Object[]{this.targetOffset, this.listSize, 0, this.pageSize - 1, true});
        if (this.cookie != null) {
            VirtualListViewControlDirContextProcessor.invokeMethod("setContextID", this.requestControlClass, control, new Class[]{byte[].class}, new Object[]{this.cookie.getCookie()});
        }
        return control;
    }

    protected void handleResponse(Object control) {
        byte[] result = (byte[])this.invokeMethod("getContextID", this.responseControlClass, control);
        Integer listSize = (Integer)this.invokeMethod("getListSize", this.responseControlClass, control);
        Integer targetOffset = (Integer)this.invokeMethod("getTargetOffset", this.responseControlClass, control);
        this.exception = (NamingException)this.invokeMethod("getException", this.responseControlClass, control);
        this.cookie = new VirtualListViewResultsCookie(result, targetOffset, listSize);
        if (this.exception != null) {
            throw LdapUtils.convertLdapException((NamingException)this.exception);
        }
    }

    protected static Object invokeMethod(String methodName, Class clazz, Object control, Class[] paramTypes, Object[] paramValues) {
        Method method = ReflectionUtils.findMethod((Class)clazz, (String)methodName, (Class[])paramTypes);
        return ReflectionUtils.invokeMethod((Method)method, (Object)control, (Object[])paramValues);
    }
}

