/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.odm.tools;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.odm.tools.AttributeSchema;
import org.springframework.ldap.odm.tools.ObjectSchema;
import org.springframework.ldap.odm.tools.SchemaReader;
import org.springframework.ldap.odm.tools.SyntaxToJavaClass;

public final class SchemaToJava {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaToJava.class);
    private static final String TEMPLATE_FILE = "oc-to-java.ftl";
    private static final String BINARY_FILE = "binary-attributes.txt";
    private static final Class<?> DEFAULT_LOADER_CLASS = SchemaToJava.class;
    private static final String DEFAULT_URL = "ldap://127.0.0.1:389";
    private static final Options DEFAULT_OPTIONS = new Options();

    private SchemaToJava() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> readBinarySet(File binarySetFile) throws IOException {
        HashSet<String> result = new HashSet<String>();
        try (BufferedReader reader = null;){
            String line;
            reader = new BufferedReader(new FileReader(binarySetFile));
            while ((line = reader.readLine()) != null) {
                String[] parts;
                String trimmed = line.trim();
                if (trimmed.length() <= 0 || trimmed.charAt(0) == '#' || (parts = trimmed.split("\\s")).length <= 0) continue;
                result.add(parts[0]);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> readSyntaxMap(File syntaxMapFile) throws IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        try (BufferedReader reader = null;){
            String line;
            reader = new BufferedReader(new FileReader(syntaxMapFile));
            while ((line = reader.readLine()) != null) {
                String trimmed = line.trim();
                if (trimmed.length() <= 0 || trimmed.charAt(0) == '#') continue;
                String[] parts = trimmed.split(",");
                if (parts.length != 2) {
                    throw new IOException(String.format("Failed to parse line \"%1$s\"", trimmed));
                }
                String partOne = parts[0].trim();
                String partTwo = parts[1].trim();
                if (partOne.length() == 0 || partTwo.length() == 0) {
                    throw new IOException(String.format("Failed to parse line \"%1$s\"", trimmed));
                }
                result.put(partOne, partTwo);
            }
        }
        return result;
    }

    private static ObjectSchema readSchema(String url, String user, String pass, SyntaxToJavaClass syntaxToJavaClass, Set<String> binarySet, Set<String> objectClasses) throws NamingException, ClassNotFoundException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.provider.url", url);
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        if (user != null) {
            env.put("java.naming.security.principal", user);
        }
        if (pass != null) {
            env.put("java.naming.security.credentials", pass);
        }
        InitialDirContext context = new InitialDirContext(env);
        DirContext schemaContext = context.getSchema("");
        SchemaReader reader = new SchemaReader(schemaContext, syntaxToJavaClass, binarySet);
        ObjectSchema schema = reader.getObjectSchema(objectClasses);
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Schema - %1$s", schema.toString()));
        }
        return schema;
    }

    private static void createCode(String packageName, String className, ObjectSchema schema, Set<SyntaxToJavaClass.ClassInfo> imports, File outputFile) throws IOException, TemplateException {
        Configuration freeMarkerConfiguration = new Configuration();
        freeMarkerConfiguration.setClassForTemplateLoading(DEFAULT_LOADER_CLASS, "");
        freeMarkerConfiguration.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("package", packageName);
        model.put("class", className);
        model.put("schema", schema);
        model.put("imports", imports);
        Template template = freeMarkerConfiguration.getTemplate(TEMPLATE_FILE);
        if (LOG.isDebugEnabled()) {
            OutputStreamWriter out = new OutputStreamWriter(System.out);
            template.process(model, (Writer)out);
            ((Writer)out).flush();
        }
        LOG.debug(String.format("Writing java to: %1$s", outputFile.getAbsolutePath()));
        FileOutputStream outputStream = new FileOutputStream(outputFile);
        OutputStreamWriter out = new OutputStreamWriter(outputStream);
        template.process(model, (Writer)out);
        ((Writer)out).flush();
        ((Writer)out).close();
    }

    private static File makeOutputFile(String outputDir, String packageName, String className) throws IOException {
        Pattern pattern = Pattern.compile("\\.");
        Matcher matcher = pattern.matcher(packageName);
        String sepToUse = File.separator;
        if (sepToUse.equals("\\")) {
            sepToUse = "\\\\";
        }
        String directoryPath = outputDir + File.separator + matcher.replaceAll(sepToUse);
        File directory = new File(directoryPath);
        File outputFile = new File(directory, className + ".java");
        LOG.debug(String.format("Attempting to create output file at %1$s", outputFile.getAbsolutePath()));
        try {
            directory.mkdirs();
            outputFile.createNewFile();
        }
        catch (SecurityException se) {
            throw new IOException(String.format("Can't write to output file %1$s", outputFile.getAbsoluteFile()), se);
        }
        catch (IOException ioe) {
            throw new IOException(String.format("Can't write to output file %1$s", outputFile.getAbsoluteFile()), ioe);
        }
        return outputFile;
    }

    private static Set<String> parseObjectClassesFlag(String objectClassesFlag) {
        HashSet<String> objectClasses = new HashSet<String>();
        for (String objectClassFlag : objectClassesFlag.split(",")) {
            if (objectClassFlag.length() <= 0) continue;
            objectClasses.add(objectClassFlag.toLowerCase(Locale.ROOT).trim());
        }
        return objectClasses;
    }

    private static void error(String message) {
        System.err.println(String.format("%1$s: %2$s", SchemaToJava.class.getSimpleName(), message));
        System.exit(1);
    }

    public static void main(String[] argv) {
        File binarySetFile;
        URL binarySetUrl;
        Set<String> objectClasses;
        String packageName;
        String className;
        PosixParser parser = new PosixParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(DEFAULT_OPTIONS, argv);
        }
        catch (ParseException ex) {
            SchemaToJava.error(ex.toString());
        }
        if (cmd.hasOption(Flag.HELP.getShort())) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(120, SchemaToJava.class.getSimpleName(), null, DEFAULT_OPTIONS, null, true);
            System.exit(0);
        }
        if ((className = cmd.getOptionValue(Flag.CLASS.getShort())) == null) {
            SchemaToJava.error("You must specify the name of a Java class to create");
        }
        if ((packageName = cmd.getOptionValue(Flag.PACKAGE.getShort())) == null) {
            SchemaToJava.error("You must specifiy a package name");
        }
        String outputDir = cmd.getOptionValue(Flag.OUTPUT_DIR.getShort(), ".");
        File outputFile = null;
        try {
            outputFile = SchemaToJava.makeOutputFile(outputDir, packageName, className);
        }
        catch (IOException ex) {
            SchemaToJava.error(ex.toString());
        }
        String url = cmd.getOptionValue(Flag.URL.getShort(), DEFAULT_URL);
        String user = cmd.getOptionValue(Flag.USERNAME.getShort());
        String pass = cmd.getOptionValue(Flag.PASSWORD.getShort());
        String objectClassesFlag = cmd.getOptionValue(Flag.OBJECTCLASS.getShort());
        if (objectClassesFlag == null) {
            SchemaToJava.error("You must specificy a package name");
        }
        if ((objectClasses = SchemaToJava.parseObjectClassesFlag(objectClassesFlag)).size() == 0) {
            SchemaToJava.error("You must specificy a package name");
        }
        String syntaxMapFileName = cmd.getOptionValue(Flag.SYNTAX_MAP.getShort(), null);
        SyntaxToJavaClass syntaxToJavaClass = new SyntaxToJavaClass(new HashMap<String, String>());
        if (syntaxMapFileName != null) {
            File syntaxMapFile = new File(syntaxMapFileName);
            if (syntaxMapFile.canRead()) {
                try {
                    syntaxToJavaClass = new SyntaxToJavaClass(SchemaToJava.readSyntaxMap(syntaxMapFile));
                }
                catch (IOException ex) {
                    SchemaToJava.error(String.format("Error reading syntax map file %1$s - %2$s", syntaxMapFile.getAbsolutePath(), ex.toString()));
                }
            } else {
                SchemaToJava.error(String.format("Cannot read syntax map file %s$1", syntaxMapFile.getAbsolutePath()));
            }
        }
        if ((binarySetUrl = DEFAULT_LOADER_CLASS.getResource(BINARY_FILE)) == null) {
            SchemaToJava.error(String.format("Can't locatate binary mappings file %1$s", BINARY_FILE));
        }
        if (!(binarySetFile = new File(binarySetUrl.getFile())).canRead()) {
            SchemaToJava.error(String.format("Can't read from binary mappings file %1$s", BINARY_FILE));
        }
        Set<String> binarySet = null;
        try {
            binarySet = SchemaToJava.readBinarySet(binarySetFile);
        }
        catch (IOException ex) {
            SchemaToJava.error(String.format("Error reading binary set file %1$s - %2$s", binarySetFile.getAbsolutePath(), ex));
        }
        ObjectSchema schema = null;
        try {
            schema = SchemaToJava.readSchema(url, user, pass, syntaxToJavaClass, binarySet, objectClasses);
        }
        catch (NamingException ne) {
            SchemaToJava.error(String.format("Error processing schema - %1$s", ne));
        }
        catch (ClassNotFoundException cnfe) {
            SchemaToJava.error(String.format("Error processing schema - %1$s", cnfe));
        }
        HashSet<SyntaxToJavaClass.ClassInfo> imports = new HashSet<SyntaxToJavaClass.ClassInfo>();
        for (AttributeSchema attributeSchema : schema.getMay()) {
            String classPackageName;
            SyntaxToJavaClass.ClassInfo classInfo = syntaxToJavaClass.getClassInfo(attributeSchema.getSyntax());
            if (classInfo == null || (classPackageName = classInfo.getPackageName()) == null || classPackageName.length() <= 0) continue;
            imports.add(classInfo);
        }
        try {
            SchemaToJava.createCode(packageName, className, schema, imports, outputFile);
        }
        catch (TemplateException te) {
            SchemaToJava.error(String.format("Error generating code - %1$s", te.toString()));
        }
        catch (IOException ioe) {
            SchemaToJava.error(String.format("Error generatign code - %1$s", ioe.toString()));
        }
    }

    static {
        DEFAULT_OPTIONS.addOption(Flag.URL.getShort(), Flag.URL.getLong(), true, "Ldap url (defaults to ldap://127.0.0.1:389)");
        DEFAULT_OPTIONS.addOption(Flag.USERNAME.getShort(), Flag.USERNAME.getLong(), true, "DN to bind with (defaults to \"\"");
        DEFAULT_OPTIONS.addOption(Flag.PASSWORD.getShort(), Flag.PASSWORD.getLong(), true, "Password to bind with (defaults to \"\"");
        DEFAULT_OPTIONS.addOption(Flag.OBJECTCLASS.getShort(), Flag.OBJECTCLASS.getLong(), true, "Comma separated list of object classes");
        DEFAULT_OPTIONS.addOption(Flag.CLASS.getShort(), Flag.CLASS.getLong(), true, "Name of the Java class to create");
        DEFAULT_OPTIONS.addOption(Flag.PACKAGE.getShort(), Flag.PACKAGE.getLong(), true, "Package to create the Java class in");
        DEFAULT_OPTIONS.addOption(Flag.SYNTAX_MAP.getShort(), Flag.SYNTAX_MAP.getLong(), true, "Syntax map file (optional)");
        DEFAULT_OPTIONS.addOption(Flag.OUTPUT_DIR.getShort(), Flag.OUTPUT_DIR.getLong(), true, "Base output directory (defaults to .)");
        DEFAULT_OPTIONS.addOption(Flag.HELP.getShort(), Flag.HELP.getLong(), false, "Print this help message");
    }

    private static enum Flag {
        URL("l", "url"),
        USERNAME("u", "username"),
        PASSWORD("p", "password"),
        OBJECTCLASS("o", "objectclasses"),
        CLASS("c", "class"),
        PACKAGE("k", "package"),
        SYNTAX_MAP("s", "syntaxmap"),
        OUTPUT_DIR("t", "outputdir"),
        HELP("h", "help");

        private String shortName;
        private String longName;

        private Flag(String shortName, String longName) {
            this.shortName = shortName;
            this.longName = longName;
        }

        public String getShort() {
            return this.shortName;
        }

        public String getLong() {
            return this.longName;
        }

        public String toString() {
            return String.format("short=%1$s, long=%2$s", this.shortName, this.longName);
        }
    }
}

