<#ftl strip_whitespace="true">

<#macro commaSeparatedList strings>
    <#local first=true/>
    <#list strings as listValue>
        <#if !first>
          , <#t/>
        <#else>
          <#local first=false/>
        </#if>
        "${listValue}"<#t/>
    </#list>
</#macro>

<#macro doAttribute attributes>
    <#list attributes as attribute>
       <#local binary=attribute.isBinary?string(", type=Type.BINARY", "")>

       <#lt/>   @Attribute(name="${attribute.name}", syntax="${attribute.syntax}"${binary})
       <#if attribute.isMultiValued>
          <#lt/>   private List<${attribute.scalarType}> ${attribute.name}=new ArrayList<${attribute.scalarType}>();
       <#else>
             <#lt/>   private ${attribute.scalarType} ${attribute.name};
       </#if>
    </#list>
</#macro>

<#macro getSet attributes>
    <#list attributes as attribute>
        <#if attribute.name!="objectClass">
            <#if attribute.isMultiValued>
                <#lt/>   public void add${attribute.name?cap_first}(${attribute.scalarType} ${attribute.name}) {
                <#lt/>      this.${attribute.name}.add(${attribute.name});
                <#lt/>   }

                <#lt/>   public void remove${attribute.name?cap_first}(${attribute.scalarType} ${attribute.name}) {
                <#lt/>      this.${attribute.name}.remove(${attribute.name});
                <#lt/>   }

                <#lt/>   public Iterator<${attribute.scalarType}> get${attribute.name?cap_first}Iterator() {
                <#lt/>      return ${attribute.name}.iterator();
                <#lt/>   }

            <#else>
                   <#lt/>   public ${attribute.scalarType} get${attribute.name?cap_first}() {
                   <#lt/>      return ${attribute.name};
                   <#lt/>   }

                <#lt/>   public void set${attribute.name?cap_first}(${attribute.scalarType} ${attribute.name}) {
                   <#lt/>      this.${attribute.name}=${attribute.name};
                   <#lt/>   }
            </#if>
        <#else>
            <#lt/>   public Iterator<String> get${attribute.name?cap_first}Iterator() {
            <#lt/>      return Collections.unmodifiableList(${attribute.name}).iterator();
            <#lt/>   }

        </#if>
    </#list>
</#macro>

<#macro equalsCode attributes>
   <#list attributes as attribute>
      <#lt/>         append(${attribute.name}, other.${attribute.name}).
   </#list>
</#macro>

<#macro hashCode attributes>
   <#list attributes as attribute>
      <#lt/>         append(${attribute.name}).
   </#list>
</#macro>

package ${package};

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.HashSet;
import java.util.ArrayList;
import java.util.Arrays;

import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

import javax.naming.Name;
<#list imports as import>
import ${import.packageName}.${import.className};
</#list>

import static org.springframework.ldap.odm.annotations.Attribute.*;
import org.springframework.ldap.odm.annotations.Attribute;
import org.springframework.ldap.odm.annotations.Entry;
import org.springframework.ldap.odm.annotations.Id;

/**
* Generated by Spring LDAP ODM to represent the LDAP object classes:
* <ul>
<#list schema.objectClass as objectClass>
* <li>${objectClass}</li>
</#list>
* </ul>
*/
@Entry(objectClasses={<@commaSeparatedList schema.objectClass/>})
public final class ${class} {

   @Id
   private Name dn;
<@doAttribute schema.must/>
<@doAttribute schema.may/>
   public Name getDn() {
      return dn;
   }

   public void setDn(Name dn) {
      this.dn=dn;
   }

<@getSet schema.must/>
<@getSet schema.may/>
   <#lt/>   @Override
   <#lt/>   public String toString() {
   <#lt/>
   <#lt/>      return new ToStringBuilder(this).
   <#lt/>         append("dn", dn).
   <#list schema.must as attribute>
   <#lt/>         append("${attribute.name}", ${attribute.name}).
   </#list>
   <#list schema.may as attribute>
   <#lt/>         append("${attribute.name}", ${attribute.name}).
   </#list>
   <#lt/>         toString();
   <#lt/>   }

   <#lt/>   @Override
   <#lt/>   public int hashCode() {
   <#lt>       return new HashCodeBuilder().
   <@hashCode schema.must/>
   <@hashCode schema.may/>
   <#lt/>      toHashCode();
   <#lt/>    }

   <#lt/>   @Override
   <#lt/>   public boolean equals(Object obj) {
   <#lt/>      if (this == obj)
   <#lt/>         return true;
   <#lt/>      if (obj == null)
   <#lt/>         return false;
   <#lt/>      if (getClass() != obj.getClass())
   <#lt/>         return false;
   <#lt/>
   <#lt/>      ${class} other = (${class}) obj;
   <#lt/>
   <#lt/>      return new EqualsBuilder().
   <#lt/>         append(dn, other.dn).
   <@equalsCode schema.must/>
   <@equalsCode schema.may/>
   <#lt/>         isEquals();
   <#lt/>   }
}


