/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.streams;

import java.util.Objects;
import java.util.Properties;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.KeyQueryMetadata;
import org.apache.kafka.streams.StoreQueryParameters;
import org.apache.kafka.streams.state.HostInfo;
import org.apache.kafka.streams.state.QueryableStoreType;
import org.jspecify.annotations.Nullable;
import org.springframework.core.retry.RetryException;
import org.springframework.core.retry.RetryTemplate;
import org.springframework.kafka.config.StreamsBuilderFactoryBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class KafkaStreamsInteractiveQueryService {
    private final StreamsBuilderFactoryBean streamsBuilderFactoryBean;
    private RetryTemplate retryTemplate = new RetryTemplate();
    private volatile KafkaStreams kafkaStreams;

    public KafkaStreamsInteractiveQueryService(StreamsBuilderFactoryBean streamsBuilderFactoryBean) {
        Assert.notNull((Object)((Object)streamsBuilderFactoryBean), (String)"StreamsBuildFactoryBean instance cannot be null.");
        this.streamsBuilderFactoryBean = streamsBuilderFactoryBean;
    }

    public void setRetryTemplate(RetryTemplate retryTemplate) {
        Assert.notNull((Object)retryTemplate, (String)"The provided RetryTemplate instance must not be null");
        this.retryTemplate = retryTemplate;
    }

    public <T> T retrieveQueryableStore(String storeName, QueryableStoreType<T> storeType) {
        this.populateKafkaStreams();
        StoreQueryParameters storeQueryParams = StoreQueryParameters.fromNameAndType((String)storeName, storeType);
        try {
            return (T)Objects.requireNonNull(this.retryTemplate.execute(() -> this.kafkaStreams.store(storeQueryParams)));
        }
        catch (RetryException ex) {
            throw new IllegalStateException("Error retrieving state store: " + storeName, ex.getCause());
        }
    }

    private void populateKafkaStreams() {
        KafkaStreams kafkaStreamsToUse = this.kafkaStreams;
        if (kafkaStreamsToUse == null) {
            kafkaStreamsToUse = this.streamsBuilderFactoryBean.getKafkaStreams();
            Assert.notNull((Object)kafkaStreamsToUse, (String)"KafkaStreams cannot be null. Make sure that the corresponding StreamsBuilderFactoryBean has started properly.");
            this.kafkaStreams = kafkaStreamsToUse;
        }
    }

    public @Nullable HostInfo getCurrentKafkaStreamsApplicationHostInfo() {
        String applicationServer;
        String[] appServerComponents;
        Properties streamsConfiguration = this.streamsBuilderFactoryBean.getStreamsConfiguration();
        if (streamsConfiguration != null && streamsConfiguration.containsKey("application.server") && (appServerComponents = StringUtils.split((String)(applicationServer = (String)streamsConfiguration.get("application.server")), (String)":")) != null) {
            return new HostInfo(appServerComponents[0], Integer.parseInt(appServerComponents[1]));
        }
        return null;
    }

    public <K> HostInfo getKafkaStreamsApplicationHostInfo(String store, K key, Serializer<K> serializer) {
        this.populateKafkaStreams();
        try {
            return this.getActiveHost(store, key, serializer);
        }
        catch (RetryException ex) {
            throw new IllegalStateException("Error when retrieving state store.", ex.getCause());
        }
    }

    private <K> HostInfo getActiveHost(String store, K key, Serializer<K> serializer) throws RetryException {
        return Objects.requireNonNull((HostInfo)this.retryTemplate.execute(() -> {
            KeyQueryMetadata keyQueryMetadata = this.kafkaStreams.queryMetadataForKey(store, key, serializer);
            if (keyQueryMetadata != null) {
                return keyQueryMetadata.activeHost();
            }
            throw new IllegalStateException("KeyQueryMetadata is not yet available.");
        }));
    }
}

