/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.mock;

import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.apache.kafka.clients.producer.MockProducer;
import org.apache.kafka.clients.producer.Producer;
import org.jspecify.annotations.Nullable;
import org.springframework.kafka.core.ProducerFactory;

public class MockProducerFactory<K, V>
implements ProducerFactory<K, V> {
    private final BiFunction<Boolean, @Nullable String, MockProducer<K, V>> producerProvider;
    private final @Nullable String defaultTxId;
    private final boolean transactional;

    public MockProducerFactory(Supplier<MockProducer<K, V>> producerProvider) {
        this.producerProvider = (tx, id) -> (MockProducer)producerProvider.get();
        this.defaultTxId = null;
        this.transactional = false;
    }

    public MockProducerFactory(BiFunction<Boolean, @Nullable String, MockProducer<K, V>> producerProvider, @Nullable String defaultTxId) {
        this.producerProvider = producerProvider;
        this.defaultTxId = defaultTxId;
        this.transactional = true;
    }

    @Override
    public boolean transactionCapable() {
        return this.transactional;
    }

    @Override
    public Producer<K, V> createProducer() {
        return this.createProducer(this.defaultTxId);
    }

    @Override
    public Producer<K, V> createProducer(@Nullable String txIdPrefix) {
        return txIdPrefix == null && this.defaultTxId == null ? (Producer)this.producerProvider.apply(false, null) : (Producer)this.producerProvider.apply(true, txIdPrefix == null ? this.defaultTxId : txIdPrefix);
    }

    @Override
    public Producer<K, V> createNonTransactionalProducer() {
        return (Producer)this.producerProvider.apply(false, null);
    }
}

