/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener.adapter;

import java.util.List;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.jspecify.annotations.Nullable;
import org.springframework.core.log.LogAccessor;
import org.springframework.kafka.listener.ConsumerRecordRecoverer;
import org.springframework.kafka.listener.adapter.BatchToRecordAdapter;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class DefaultBatchToRecordAdapter<K, V>
implements BatchToRecordAdapter<K, V> {
    private static final LogAccessor LOGGER = new LogAccessor(DefaultBatchToRecordAdapter.class);
    private final ConsumerRecordRecoverer recoverer;

    public DefaultBatchToRecordAdapter() {
        this((record, ex) -> LOGGER.error((Throwable)ex, () -> "Failed to process " + String.valueOf(record)));
    }

    public DefaultBatchToRecordAdapter(ConsumerRecordRecoverer recoverer) {
        Assert.notNull((Object)recoverer, (String)"'recoverer' cannot be null");
        this.recoverer = recoverer;
    }

    @Override
    public void adapt(List<Message<?>> messages, List<ConsumerRecord<K, V>> records, @Nullable Acknowledgment ack, @Nullable Consumer<?, ?> consumer, BatchToRecordAdapter.Callback<K, V> callback) {
        for (int i = 0; i < messages.size(); ++i) {
            Message<?> message = messages.get(i);
            try {
                callback.invoke(records.get(i), ack, consumer, message);
                continue;
            }
            catch (Exception e) {
                this.recoverer.accept(records.get(i), e);
            }
        }
    }
}

