/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.core.log.LogAccessor;
import org.springframework.kafka.config.AbstractKafkaListenerEndpoint;
import org.springframework.kafka.config.ContainerCustomizer;
import org.springframework.kafka.config.ContainerPostProcessor;
import org.springframework.kafka.config.KafkaListenerContainerFactory;
import org.springframework.kafka.config.KafkaListenerEndpoint;
import org.springframework.kafka.config.KafkaListenerEndpointAdapter;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.listener.AbstractMessageListenerContainer;
import org.springframework.kafka.listener.AfterRollbackProcessor;
import org.springframework.kafka.listener.BatchInterceptor;
import org.springframework.kafka.listener.CommonErrorHandler;
import org.springframework.kafka.listener.ContainerProperties;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.kafka.listener.RecordInterceptor;
import org.springframework.kafka.listener.adapter.BatchToRecordAdapter;
import org.springframework.kafka.listener.adapter.RecordFilterStrategy;
import org.springframework.kafka.listener.adapter.ReplyHeadersConfigurer;
import org.springframework.kafka.requestreply.ReplyingKafkaOperations;
import org.springframework.kafka.support.JavaUtils;
import org.springframework.kafka.support.TopicPartitionOffset;
import org.springframework.kafka.support.converter.BatchMessageConverter;
import org.springframework.kafka.support.converter.RecordMessageConverter;
import org.springframework.util.Assert;

public abstract class AbstractKafkaListenerContainerFactory<C extends AbstractMessageListenerContainer<K, V>, K, V>
implements KafkaListenerContainerFactory<C>,
ApplicationEventPublisherAware,
ApplicationContextAware {
    protected final LogAccessor logger = new LogAccessor(LogFactory.getLog(this.getClass()));
    private final ContainerProperties containerProperties = new ContainerProperties((Pattern)null);
    private @Nullable CommonErrorHandler commonErrorHandler;
    private @Nullable ConsumerFactory<? super K, ? super V> consumerFactory;
    private @Nullable Boolean autoStartup;
    private @Nullable Integer phase;
    private @Nullable RecordMessageConverter recordMessageConverter;
    private @Nullable BatchMessageConverter batchMessageConverter;
    private @Nullable RecordFilterStrategy<? super K, ? super V> recordFilterStrategy;
    private @Nullable Boolean ackDiscarded;
    private @Nullable Boolean batchListener;
    private @Nullable ApplicationEventPublisher applicationEventPublisher;
    private @Nullable KafkaTemplate<?, ?> replyTemplate;
    private @Nullable AfterRollbackProcessor<? super K, ? super V> afterRollbackProcessor;
    private @Nullable ReplyHeadersConfigurer replyHeadersConfigurer;
    private @Nullable Boolean missingTopicsFatal;
    private @Nullable RecordInterceptor<K, V> recordInterceptor;
    private @Nullable BatchInterceptor<K, V> batchInterceptor;
    private @Nullable BatchToRecordAdapter<K, V> batchToRecordAdapter;
    private @Nullable ApplicationContext applicationContext;
    private @Nullable ContainerCustomizer<K, V, C> containerCustomizer;
    private @Nullable String correlationHeaderName;
    private @Nullable Boolean changeConsumerThreadName;
    private @Nullable Function<MessageListenerContainer, String> threadNameSupplier;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setConsumerFactory(ConsumerFactory<? super K, ? super V> consumerFactory) {
        this.consumerFactory = consumerFactory;
    }

    public @Nullable ConsumerFactory<? super K, ? super V> getConsumerFactory() {
        return this.consumerFactory;
    }

    public void setAutoStartup(Boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public void setRecordMessageConverter(RecordMessageConverter recordMessageConverter) {
        this.recordMessageConverter = recordMessageConverter;
    }

    public void setBatchMessageConverter(BatchMessageConverter batchMessageConverter) {
        this.batchMessageConverter = batchMessageConverter;
    }

    public void setRecordFilterStrategy(RecordFilterStrategy<? super K, ? super V> recordFilterStrategy) {
        this.recordFilterStrategy = recordFilterStrategy;
    }

    public void setAckDiscarded(Boolean ackDiscarded) {
        this.ackDiscarded = ackDiscarded;
    }

    public @Nullable Boolean isBatchListener() {
        return this.batchListener;
    }

    public void setBatchListener(Boolean batchListener) {
        this.batchListener = batchListener;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void setReplyTemplate(KafkaTemplate<?, ?> replyTemplate) {
        if (replyTemplate instanceof ReplyingKafkaOperations) {
            this.logger.warn((CharSequence)"The 'replyTemplate' should not be an implementation of 'ReplyingKafkaOperations'; such implementations are for client-side request/reply operations; here we are simply sending a reply to an incoming request so the reply container will never be used and will consume unnecessary resources.");
        }
        this.replyTemplate = replyTemplate;
    }

    public void setCommonErrorHandler(CommonErrorHandler commonErrorHandler) {
        this.commonErrorHandler = commonErrorHandler;
    }

    public void setAfterRollbackProcessor(AfterRollbackProcessor<? super K, ? super V> afterRollbackProcessor) {
        this.afterRollbackProcessor = afterRollbackProcessor;
    }

    public void setReplyHeadersConfigurer(ReplyHeadersConfigurer replyHeadersConfigurer) {
        this.replyHeadersConfigurer = replyHeadersConfigurer;
    }

    public void setMissingTopicsFatal(boolean missingTopicsFatal) {
        this.missingTopicsFatal = missingTopicsFatal;
    }

    public ContainerProperties getContainerProperties() {
        return this.containerProperties;
    }

    public @Nullable RecordInterceptor<K, V> getRecordInterceptor() {
        return this.recordInterceptor;
    }

    public void setRecordInterceptor(RecordInterceptor<K, V> recordInterceptor) {
        this.recordInterceptor = recordInterceptor;
    }

    public @Nullable BatchInterceptor<K, V> getBatchInterceptor() {
        return this.batchInterceptor;
    }

    public void setBatchInterceptor(BatchInterceptor<K, V> batchInterceptor) {
        this.batchInterceptor = batchInterceptor;
    }

    public void setBatchToRecordAdapter(BatchToRecordAdapter<K, V> batchToRecordAdapter) {
        this.batchToRecordAdapter = batchToRecordAdapter;
    }

    public void setContainerCustomizer(ContainerCustomizer<K, V, C> containerCustomizer) {
        this.containerCustomizer = containerCustomizer;
    }

    public void setCorrelationHeaderName(String correlationHeaderName) {
        this.correlationHeaderName = correlationHeaderName;
    }

    public void setChangeConsumerThreadName(boolean changeConsumerThreadName) {
        this.changeConsumerThreadName = changeConsumerThreadName;
    }

    public void setThreadNameSupplier(Function<MessageListenerContainer, String> threadNameSupplier) {
        Assert.notNull(threadNameSupplier, (String)"'threadNameSupplier' cannot be null");
        this.threadNameSupplier = threadNameSupplier;
    }

    @Override
    public C createListenerContainer(KafkaListenerEndpoint endpoint) {
        C instance = this.createContainerInstance(endpoint);
        JavaUtils.INSTANCE.acceptIfNotNull(endpoint.getId(), arg_0 -> instance.setBeanName(arg_0)).acceptIfNotNull(endpoint.getMainListenerId(), arg_0 -> instance.setMainListenerId(arg_0));
        if (endpoint instanceof AbstractKafkaListenerEndpoint) {
            this.configureEndpoint((AbstractKafkaListenerEndpoint)endpoint);
        }
        if (Boolean.TRUE.equals(endpoint.getBatchListener())) {
            endpoint.setupListenerContainer((MessageListenerContainer)instance, this.batchMessageConverter);
        } else {
            endpoint.setupListenerContainer((MessageListenerContainer)instance, this.recordMessageConverter);
        }
        this.initializeContainer(instance, endpoint);
        this.customizeContainer(instance, endpoint);
        return instance;
    }

    private void configureEndpoint(AbstractKafkaListenerEndpoint<K, V> aklEndpoint) {
        if (aklEndpoint.getRecordFilterStrategy() == null) {
            JavaUtils.INSTANCE.acceptIfNotNull(this.recordFilterStrategy, aklEndpoint::setRecordFilterStrategy);
        }
        JavaUtils.INSTANCE.acceptIfNotNull(this.ackDiscarded, aklEndpoint::setAckDiscarded).acceptIfNotNull(this.replyTemplate, aklEndpoint::setReplyTemplate).acceptIfNotNull(this.replyHeadersConfigurer, aklEndpoint::setReplyHeadersConfigurer).acceptIfNotNull(this.batchToRecordAdapter, aklEndpoint::setBatchToRecordAdapter).acceptIfNotNull(this.correlationHeaderName, aklEndpoint::setCorrelationHeaderName);
        if (aklEndpoint.getBatchListener() == null) {
            JavaUtils.INSTANCE.acceptIfNotNull(this.batchListener, aklEndpoint::setBatchListener);
        }
    }

    protected abstract C createContainerInstance(KafkaListenerEndpoint var1);

    protected void initializeContainer(C instance, KafkaListenerEndpoint endpoint) {
        ContainerProperties properties = ((AbstractMessageListenerContainer)instance).getContainerProperties();
        BeanUtils.copyProperties((Object)this.containerProperties, (Object)properties, (String[])new String[]{"topics", "topicPartitions", "topicPattern", "messageListener", "ackCount", "ackTime", "subBatchPerPartition", "kafkaConsumerProperties"});
        JavaUtils.INSTANCE.acceptIfNotNull(this.afterRollbackProcessor, arg_0 -> instance.setAfterRollbackProcessor(arg_0)).acceptIfCondition(this.containerProperties.getAckCount() > 0, this.containerProperties.getAckCount(), properties::setAckCount).acceptIfCondition(this.containerProperties.getAckTime() > 0L, this.containerProperties.getAckTime(), properties::setAckTime).acceptIfNotNull(this.containerProperties.getSubBatchPerPartition(), properties::setSubBatchPerPartition).acceptIfNotNull(this.commonErrorHandler, arg_0 -> instance.setCommonErrorHandler(arg_0)).acceptIfNotNull(this.missingTopicsFatal, ((AbstractMessageListenerContainer)instance).getContainerProperties()::setMissingTopicsFatal).acceptIfNotNull(this.changeConsumerThreadName, arg_0 -> instance.setChangeConsumerThreadName(arg_0)).acceptIfNotNull(this.threadNameSupplier, arg_0 -> instance.setThreadNameSupplier(arg_0));
        Boolean autoStart = endpoint.getAutoStartup();
        if (autoStart != null) {
            ((AbstractMessageListenerContainer)instance).setAutoStartup(autoStart);
        } else if (this.autoStartup != null) {
            ((AbstractMessageListenerContainer)instance).setAutoStartup(this.autoStartup);
        }
        ((AbstractMessageListenerContainer)instance).setRecordInterceptor(this.recordInterceptor);
        ((AbstractMessageListenerContainer)instance).setBatchInterceptor(this.batchInterceptor);
        JavaUtils.INSTANCE.acceptIfNotNull(this.phase, arg_0 -> instance.setPhase(arg_0)).acceptIfNotNull(this.applicationContext, arg_0 -> instance.setApplicationContext(arg_0)).acceptIfNotNull(this.applicationEventPublisher, arg_0 -> instance.setApplicationEventPublisher(arg_0)).acceptIfHasText(endpoint.getGroupId(), ((AbstractMessageListenerContainer)instance).getContainerProperties()::setGroupId).acceptIfHasText(endpoint.getClientIdPrefix(), ((AbstractMessageListenerContainer)instance).getContainerProperties()::setClientId).acceptIfNotNull(endpoint.getConsumerProperties(), ((AbstractMessageListenerContainer)instance).getContainerProperties()::setKafkaConsumerProperties).acceptIfNotNull(endpoint.getListenerInfo(), arg_0 -> instance.setListenerInfo(arg_0)).acceptIfNotNull(endpoint.getAckMode(), ackMode -> properties.setAckMode(ContainerProperties.AckMode.valueOf(ackMode.toUpperCase())));
    }

    @Override
    public C createContainer(final TopicPartitionOffset ... topicsAndPartitions) {
        return this.createContainer(new KafkaListenerEndpointAdapter(this){
            final /* synthetic */ AbstractKafkaListenerContainerFactory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public TopicPartitionOffset[] getTopicPartitionsToAssign() {
                return Arrays.copyOf(topicsAndPartitions, topicsAndPartitions.length);
            }
        });
    }

    @Override
    public C createContainer(final String ... topics) {
        return this.createContainer(new KafkaListenerEndpointAdapter(this){
            final /* synthetic */ AbstractKafkaListenerContainerFactory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Collection<String> getTopics() {
                return Arrays.asList(topics);
            }
        });
    }

    @Override
    public C createContainer(final Pattern topicPattern) {
        return this.createContainer(new KafkaListenerEndpointAdapter(this){
            final /* synthetic */ AbstractKafkaListenerContainerFactory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Pattern getTopicPattern() {
                return topicPattern;
            }
        });
    }

    protected C createContainer(KafkaListenerEndpoint endpoint) {
        C container = this.createContainerInstance(endpoint);
        this.initializeContainer(container, endpoint);
        this.customizeContainer(container, endpoint);
        return container;
    }

    protected void customizeContainer(C instance, KafkaListenerEndpoint endpoint) {
        ContainerPostProcessor<?, ?, ?> containerPostProcessor;
        if (this.containerCustomizer != null) {
            this.containerCustomizer.configure(instance);
        }
        if ((containerPostProcessor = endpoint.getContainerPostProcessor()) != null) {
            containerPostProcessor.postProcess(instance);
        }
    }
}

