/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka;

import org.jspecify.annotations.Nullable;
import org.springframework.core.NestedRuntimeException;
import org.springframework.core.log.LogAccessor;
import org.springframework.util.Assert;

public class KafkaException
extends NestedRuntimeException {
    private final Level logLevel;

    public KafkaException(String message) {
        this(message, Level.ERROR, null);
    }

    public KafkaException(String message, @Nullable Throwable cause) {
        this(message, Level.ERROR, cause);
    }

    public KafkaException(String message, Level level, @Nullable Throwable cause) {
        super(message, cause);
        Assert.notNull((Object)((Object)level), (String)"'level' cannot be null");
        this.logLevel = level;
    }

    public void selfLog(String message, LogAccessor logger) {
        switch (this.logLevel.ordinal()) {
            case 0: {
                logger.fatal((Throwable)((Object)this), (CharSequence)message);
                break;
            }
            case 1: {
                logger.error((Throwable)((Object)this), (CharSequence)message);
                break;
            }
            case 2: {
                logger.warn((Throwable)((Object)this), (CharSequence)message);
                break;
            }
            case 3: {
                logger.info((Throwable)((Object)this), (CharSequence)message);
                break;
            }
            case 4: {
                logger.debug((Throwable)((Object)this), (CharSequence)message);
                break;
            }
            case 5: {
                logger.trace((Throwable)((Object)this), (CharSequence)message);
                break;
            }
            default: {
                logger.error((Throwable)((Object)this), (CharSequence)message);
            }
        }
    }

    public static enum Level {
        FATAL,
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE;

    }
}

