/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support;

import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.core.log.LogAccessor;
import org.springframework.util.Assert;

public final class LogIfLevelEnabled {
    private final LogAccessor logger;
    private final Level level;

    public LogIfLevelEnabled(LogAccessor logger, Level level) {
        Assert.notNull((Object)logger, (String)"'logger' cannot be null");
        Assert.notNull((Object)((Object)level), (String)"'level' cannot be null");
        this.logger = logger;
        this.level = level;
    }

    public void log(Supplier<CharSequence> messageSupplier) {
        switch (this.level.ordinal()) {
            case 0: {
                this.fatal(messageSupplier, null);
                break;
            }
            case 1: {
                this.error(messageSupplier, null);
                break;
            }
            case 2: {
                this.warn(messageSupplier, null);
                break;
            }
            case 3: {
                this.info(messageSupplier, null);
                break;
            }
            case 4: {
                this.debug(messageSupplier, null);
                break;
            }
            case 5: {
                this.trace(messageSupplier, null);
            }
        }
    }

    public void log(Supplier<CharSequence> messageSupplier, Throwable thrown) {
        switch (this.level.ordinal()) {
            case 0: {
                this.fatal(messageSupplier, thrown);
                break;
            }
            case 1: {
                this.error(messageSupplier, thrown);
                break;
            }
            case 2: {
                this.warn(messageSupplier, thrown);
                break;
            }
            case 3: {
                this.info(messageSupplier, thrown);
                break;
            }
            case 4: {
                this.debug(messageSupplier, thrown);
                break;
            }
            case 5: {
                this.trace(messageSupplier, thrown);
            }
        }
    }

    private void fatal(Supplier<CharSequence> messageSupplier, @Nullable Throwable thrown) {
        if (thrown != null) {
            this.logger.fatal(thrown, messageSupplier);
        } else {
            this.logger.fatal(messageSupplier);
        }
    }

    private void error(Supplier<CharSequence> messageSupplier, @Nullable Throwable thrown) {
        if (thrown != null) {
            this.logger.error(thrown, messageSupplier);
        } else {
            this.logger.error(messageSupplier);
        }
    }

    private void warn(Supplier<CharSequence> messageSupplier, @Nullable Throwable thrown) {
        if (thrown != null) {
            this.logger.warn(thrown, messageSupplier);
        } else {
            this.logger.warn(messageSupplier);
        }
    }

    private void info(Supplier<CharSequence> messageSupplier, @Nullable Throwable thrown) {
        if (thrown != null) {
            this.logger.info(thrown, messageSupplier);
        } else {
            this.logger.info(messageSupplier);
        }
    }

    private void debug(Supplier<CharSequence> messageSupplier, @Nullable Throwable thrown) {
        if (thrown != null) {
            this.logger.debug(thrown, messageSupplier);
        } else {
            this.logger.debug(messageSupplier);
        }
    }

    private void trace(Supplier<CharSequence> messageSupplier, @Nullable Throwable thrown) {
        if (thrown != null) {
            this.logger.trace(thrown, messageSupplier);
        } else {
            this.logger.trace(messageSupplier);
        }
    }

    public static enum Level {
        FATAL,
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE;

    }
}

