/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.serializer;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.kafka.common.serialization.Serde;
import org.jspecify.annotations.Nullable;
import org.springframework.core.ResolvableType;
import org.springframework.kafka.support.JacksonUtils;
import org.springframework.kafka.support.mapping.Jackson2JavaTypeMapper;
import org.springframework.kafka.support.serializer.JsonDeserializer;
import org.springframework.kafka.support.serializer.JsonSerializer;
import org.springframework.util.Assert;

public class JsonSerde<T>
implements Serde<T> {
    private final JsonSerializer<T> jsonSerializer;
    private final JsonDeserializer<T> jsonDeserializer;

    public JsonSerde() {
        this((JavaType)null, JacksonUtils.enhancedObjectMapper());
    }

    public JsonSerde(@Nullable Class<? super T> targetType) {
        this(targetType, JacksonUtils.enhancedObjectMapper());
    }

    public JsonSerde(@Nullable TypeReference<? super T> targetType) {
        this(targetType, JacksonUtils.enhancedObjectMapper());
    }

    public JsonSerde(@Nullable JavaType targetType) {
        this(targetType, JacksonUtils.enhancedObjectMapper());
    }

    public JsonSerde(ObjectMapper objectMapper) {
        this((JavaType)null, objectMapper);
    }

    public JsonSerde(@Nullable TypeReference<? super T> targetType, ObjectMapper objectMapper) {
        this(targetType == null ? null : objectMapper.constructType(targetType.getType()), objectMapper);
    }

    public JsonSerde(@Nullable Class<? super T> targetType, ObjectMapper objectMapper) {
        this(targetType == null ? null : objectMapper.constructType(targetType), objectMapper);
    }

    public JsonSerde(@Nullable JavaType targetTypeArg, @Nullable ObjectMapper objectMapperArg) {
        Class resolvedGeneric;
        ObjectMapper objectMapper;
        ObjectMapper objectMapper2 = objectMapper = objectMapperArg == null ? JacksonUtils.enhancedObjectMapper() : objectMapperArg;
        JavaType actualJavaType = targetTypeArg != null ? targetTypeArg : ((resolvedGeneric = ResolvableType.forClass(this.getClass()).getSuperType().resolveGeneric(new int[]{0})) != null ? objectMapper.constructType((Type)resolvedGeneric) : null);
        this.jsonSerializer = new JsonSerializer(actualJavaType, objectMapper);
        this.jsonDeserializer = new JsonDeserializer(actualJavaType, objectMapper);
    }

    public JsonSerde(JsonSerializer<T> jsonSerializer, JsonDeserializer<T> jsonDeserializer) {
        Assert.notNull(jsonSerializer, (String)"'jsonSerializer' must not be null.");
        Assert.notNull(jsonDeserializer, (String)"'jsonDeserializer' must not be null.");
        this.jsonSerializer = jsonSerializer;
        this.jsonDeserializer = jsonDeserializer;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.jsonSerializer.configure(configs, isKey);
        this.jsonDeserializer.configure(configs, isKey);
    }

    public void close() {
        this.jsonSerializer.close();
        this.jsonDeserializer.close();
    }

    public JsonSerializer<T> serializer() {
        return this.jsonSerializer;
    }

    public JsonDeserializer<T> deserializer() {
        return this.jsonDeserializer;
    }

    public <X> JsonSerde<X> copyWithType(Class<? super X> newTargetType) {
        return new JsonSerde<X>(this.jsonSerializer.copyWithType(newTargetType), this.jsonDeserializer.copyWithType(newTargetType));
    }

    public <X> JsonSerde<X> copyWithType(TypeReference<? super X> newTargetType) {
        return new JsonSerde<X>(this.jsonSerializer.copyWithType(newTargetType), this.jsonDeserializer.copyWithType(newTargetType));
    }

    public <X> JsonSerde<X> copyWithType(JavaType newTargetType) {
        return new JsonSerde(this.jsonSerializer.copyWithType(newTargetType), this.jsonDeserializer.copyWithType(newTargetType));
    }

    public JsonSerde<T> forKeys() {
        this.jsonSerializer.forKeys();
        this.jsonDeserializer.forKeys();
        return this;
    }

    public JsonSerde<T> noTypeInfo() {
        this.jsonSerializer.noTypeInfo();
        return this;
    }

    public JsonSerde<T> dontRemoveTypeHeaders() {
        this.jsonDeserializer.dontRemoveTypeHeaders();
        return this;
    }

    public JsonSerde<T> ignoreTypeHeaders() {
        this.jsonDeserializer.ignoreTypeHeaders();
        return this;
    }

    public JsonSerde<T> typeMapper(Jackson2JavaTypeMapper mapper) {
        this.jsonSerializer.setTypeMapper(mapper);
        this.jsonDeserializer.setTypeMapper(mapper);
        return this;
    }
}

