/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.retrytopic;

import java.time.Clock;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.springframework.kafka.KafkaException;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.config.KafkaListenerContainerFactory;
import org.springframework.kafka.config.KafkaListenerEndpoint;
import org.springframework.kafka.listener.CommonErrorHandler;
import org.springframework.kafka.listener.ConcurrentMessageListenerContainer;
import org.springframework.kafka.listener.ContainerProperties;
import org.springframework.kafka.listener.DeadLetterPublishingRecoverer;
import org.springframework.kafka.listener.DefaultErrorHandler;
import org.springframework.kafka.listener.KafkaConsumerBackoffManager;
import org.springframework.kafka.listener.MessageListener;
import org.springframework.kafka.listener.adapter.KafkaBackoffAwareMessageListenerAdapter;
import org.springframework.kafka.retrytopic.DeadLetterPublishingRecovererFactory;
import org.springframework.kafka.support.TopicPartitionOffset;
import org.springframework.util.Assert;
import org.springframework.util.backoff.BackOff;

public class ListenerContainerFactoryConfigurer {
    private @Nullable BackOff providedBlockingBackOff;
    private @Nullable Class<? extends Exception>[] blockingExceptionTypes;
    private boolean retainStandardFatal;
    private Consumer<ConcurrentMessageListenerContainer<?, ?>> containerCustomizer = container -> {};
    private Consumer<DefaultErrorHandler> errorHandlerCustomizer = errorHandler -> {};
    private final DeadLetterPublishingRecovererFactory deadLetterPublishingRecovererFactory;
    private final KafkaConsumerBackoffManager kafkaConsumerBackoffManager;
    private final Clock clock;

    public ListenerContainerFactoryConfigurer(KafkaConsumerBackoffManager kafkaConsumerBackoffManager, DeadLetterPublishingRecovererFactory deadLetterPublishingRecovererFactory, Clock clock) {
        this.kafkaConsumerBackoffManager = kafkaConsumerBackoffManager;
        this.deadLetterPublishingRecovererFactory = deadLetterPublishingRecovererFactory;
        this.clock = clock;
    }

    @Deprecated(since="3.2", forRemoval=true)
    public KafkaListenerContainerFactory<?> decorateFactory(ConcurrentKafkaListenerContainerFactory<?, ?> factory, Configuration configuration) {
        return this.decorateFactory(factory);
    }

    @Deprecated(since="3.2", forRemoval=true)
    public KafkaListenerContainerFactory<?> decorateFactoryWithoutSettingContainerProperties(ConcurrentKafkaListenerContainerFactory<?, ?> factory, Configuration configuration) {
        return this.decorateFactory(factory);
    }

    public KafkaListenerContainerFactory<?> decorateFactory(ConcurrentKafkaListenerContainerFactory<?, ?> factory) {
        return new RetryTopicListenerContainerFactoryDecorator(factory);
    }

    public void setBlockingRetriesBackOff(BackOff blockingBackOff) {
        Assert.notNull((Object)blockingBackOff, (String)"The provided BackOff cannot be null");
        Assert.state((this.providedBlockingBackOff == null ? 1 : 0) != 0, () -> "Blocking retries back off has already been set. Current: " + String.valueOf(this.providedBlockingBackOff) + " You provided: " + String.valueOf(blockingBackOff));
        this.providedBlockingBackOff = blockingBackOff;
    }

    @SafeVarargs
    public final void setBlockingRetryableExceptions(Class<? extends Exception> ... exceptionTypes) {
        Assert.notNull(exceptionTypes, (String)"The exception types cannot be null");
        Assert.noNullElements((Object[])exceptionTypes, (String)"The exception types cannot have null elements");
        Assert.state((this.blockingExceptionTypes == null ? 1 : 0) != 0, () -> "Blocking retryable exceptions have already been set.Current ones: " + Arrays.toString(this.blockingExceptionTypes) + " You provided: " + Arrays.toString(exceptionTypes));
        this.blockingExceptionTypes = Arrays.copyOf(exceptionTypes, exceptionTypes.length);
    }

    public void setRetainStandardFatal(boolean retainStandardFatal) {
        this.retainStandardFatal = retainStandardFatal;
    }

    public void setContainerCustomizer(Consumer<ConcurrentMessageListenerContainer<?, ?>> containerCustomizer) {
        Assert.notNull(containerCustomizer, (String)"'containerCustomizer' cannot be null");
        this.containerCustomizer = containerCustomizer;
    }

    public void setErrorHandlerCustomizer(Consumer<DefaultErrorHandler> errorHandlerCustomizer) {
        this.errorHandlerCustomizer = errorHandlerCustomizer;
    }

    protected CommonErrorHandler createErrorHandler(DeadLetterPublishingRecoverer deadLetterPublishingRecoverer) {
        DefaultErrorHandler errorHandler = this.createDefaultErrorHandlerInstance(deadLetterPublishingRecoverer);
        errorHandler.defaultFalse(this.retainStandardFatal);
        errorHandler.setCommitRecovered(true);
        errorHandler.setLogLevel(KafkaException.Level.DEBUG);
        if (this.blockingExceptionTypes != null) {
            errorHandler.addRetryableExceptions(this.blockingExceptionTypes);
        }
        this.errorHandlerCustomizer.accept(errorHandler);
        return errorHandler;
    }

    protected DefaultErrorHandler createDefaultErrorHandlerInstance(DeadLetterPublishingRecoverer deadLetterPublishingRecoverer) {
        return this.providedBlockingBackOff != null ? new DefaultErrorHandler(deadLetterPublishingRecoverer, this.providedBlockingBackOff) : new DefaultErrorHandler(deadLetterPublishingRecoverer);
    }

    protected void setupBackoffAwareMessageListenerAdapter(ConcurrentMessageListenerContainer<?, ?> container) {
        MessageListener listener = this.checkAndCast(container.getContainerProperties().getMessageListener(), MessageListener.class);
        container.setupMessageListener(new KafkaBackoffAwareMessageListenerAdapter(listener, this.kafkaConsumerBackoffManager, container.getListenerId(), this.clock));
        this.containerCustomizer.accept(container);
    }

    private <T> T checkAndCast(Object obj, Class<T> clazz) {
        Assert.isAssignable(clazz, obj.getClass(), () -> String.format("The provided class %s is not assignable from %s", obj.getClass().getSimpleName(), clazz.getSimpleName()));
        return (T)obj;
    }

    private class RetryTopicListenerContainerFactoryDecorator
    implements KafkaListenerContainerFactory<ConcurrentMessageListenerContainer<?, ?>> {
        private final ConcurrentKafkaListenerContainerFactory<?, ?> delegate;

        RetryTopicListenerContainerFactoryDecorator(ConcurrentKafkaListenerContainerFactory<?, ?> delegate) {
            this.delegate = delegate;
        }

        @Override
        public ConcurrentMessageListenerContainer<?, ?> createListenerContainer(KafkaListenerEndpoint endpoint) {
            return this.decorate((ConcurrentMessageListenerContainer)this.delegate.createListenerContainer(endpoint));
        }

        private ConcurrentMessageListenerContainer<?, ?> decorate(ConcurrentMessageListenerContainer<?, ?> listenerContainer) {
            ContainerProperties.AckMode ackMode;
            String mainListenerId = listenerContainer.getMainListenerId();
            if (mainListenerId == null) {
                mainListenerId = listenerContainer.getListenerId();
            }
            CommonErrorHandler errorHandler = ListenerContainerFactoryConfigurer.this.createErrorHandler(ListenerContainerFactoryConfigurer.this.deadLetterPublishingRecovererFactory.create(mainListenerId));
            if (listenerContainer.getContainerProperties().isAsyncAcks() && (ContainerProperties.AckMode.MANUAL.equals((Object)(ackMode = listenerContainer.getContainerProperties().getAckMode())) || ContainerProperties.AckMode.MANUAL_IMMEDIATE.equals((Object)ackMode)) && errorHandler instanceof DefaultErrorHandler) {
                DefaultErrorHandler deh = (DefaultErrorHandler)errorHandler;
                deh.setSeekAfterError(false);
            }
            listenerContainer.setCommonErrorHandler(errorHandler);
            ListenerContainerFactoryConfigurer.this.setupBackoffAwareMessageListenerAdapter(listenerContainer);
            return listenerContainer;
        }

        @Override
        public ConcurrentMessageListenerContainer<?, ?> createContainer(TopicPartitionOffset ... topicPartitions) {
            return this.decorate((ConcurrentMessageListenerContainer)this.delegate.createContainer(topicPartitions));
        }

        @Override
        public ConcurrentMessageListenerContainer<?, ?> createContainer(String ... topics) {
            return this.decorate((ConcurrentMessageListenerContainer)this.delegate.createContainer(topics));
        }

        @Override
        public ConcurrentMessageListenerContainer<?, ?> createContainer(Pattern topicPattern) {
            return this.decorate((ConcurrentMessageListenerContainer)this.delegate.createContainer(topicPattern));
        }
    }

    @Deprecated(since="3.2", forRemoval=true)
    static class Configuration {
        private final List<Long> backOffValues;

        Configuration(List<Long> backOffValues) {
            this.backOffValues = backOffValues;
        }
    }
}

