/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.core;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.springframework.kafka.core.KafkaOperations;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.util.Assert;

public class RoutingKafkaTemplate
extends KafkaTemplate<Object, Object> {
    private static final String THIS_METHOD_IS_NOT_SUPPORTED = "This method is not supported";
    private final Map<Pattern, ProducerFactory<Object, Object>> factoryMatchers;
    private final ConcurrentMap<String, ProducerFactory<Object, Object>> factoryMap = new ConcurrentHashMap<String, ProducerFactory<Object, Object>>();

    public RoutingKafkaTemplate(Map<Pattern, ProducerFactory<Object, Object>> factories) {
        super(() -> {
            throw new UnsupportedOperationException();
        });
        Assert.isTrue((boolean)factories.values().stream().noneMatch(ProducerFactory::transactionCapable), (String)"Transactional factories are not supported");
        this.factoryMatchers = new LinkedHashMap<Pattern, ProducerFactory<Object, Object>>(factories);
    }

    @Override
    public ProducerFactory<Object, Object> getProducerFactory() {
        throw new UnsupportedOperationException(THIS_METHOD_IS_NOT_SUPPORTED);
    }

    @Override
    public ProducerFactory<Object, Object> getProducerFactory(String topic) {
        ProducerFactory producerFactory = this.factoryMap.computeIfAbsent(topic, key -> {
            for (Map.Entry<Pattern, ProducerFactory<Object, Object>> entry : this.factoryMatchers.entrySet()) {
                if (!entry.getKey().matcher(topic).matches()) continue;
                return entry.getValue();
            }
            return null;
        });
        Assert.state((producerFactory != null ? 1 : 0) != 0, (String)("No producer factory found for topic: " + topic));
        return producerFactory;
    }

    @Override
    public <T> T execute(KafkaOperations.ProducerCallback<Object, Object, T> callback) {
        throw new UnsupportedOperationException(THIS_METHOD_IS_NOT_SUPPORTED);
    }

    @Override
    public <T> T executeInTransaction(KafkaOperations.OperationsCallback<Object, Object, T> callback) {
        throw new UnsupportedOperationException(THIS_METHOD_IS_NOT_SUPPORTED);
    }

    @Override
    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> offsets, ConsumerGroupMetadata groupMetadata) {
        throw new UnsupportedOperationException(THIS_METHOD_IS_NOT_SUPPORTED);
    }

    @Override
    public Map<MetricName, ? extends Metric> metrics() {
        throw new UnsupportedOperationException(THIS_METHOD_IS_NOT_SUPPORTED);
    }

    @Override
    public void flush() {
        throw new UnsupportedOperationException(THIS_METHOD_IS_NOT_SUPPORTED);
    }
}

