/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.serializer;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogAccessor;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public abstract class DelegatingByTopicSerialization<T extends Closeable>
implements Closeable {
    private static final String UNCHECKED = "unchecked";
    private static final LogAccessor LOGGER = new LogAccessor(LogFactory.getLog(DelegatingByTopicSerialization.class));
    public static final String VALUE_SERIALIZATION_TOPIC_CONFIG = "spring.kafka.value.serialization.bytopic.config";
    public static final String KEY_SERIALIZATION_TOPIC_CONFIG = "spring.kafka.key.serialization.bytopic.config";
    public static final String VALUE_SERIALIZATION_TOPIC_DEFAULT = "spring.kafka.value.serialization.bytopic.default";
    public static final String KEY_SERIALIZATION_TOPIC_DEFAULT = "spring.kafka.key.serialization.bytopic.default";
    public static final String CASE_SENSITIVE = "spring.kafka.value.serialization.bytopic.case.insensitive";
    private final Map<Pattern, T> delegates = new ConcurrentHashMap<Pattern, T>();
    private final Set<String> patterns = ConcurrentHashMap.newKeySet();
    private T defaultDelegate;
    private boolean forKeys;
    private boolean cased = true;

    public DelegatingByTopicSerialization() {
    }

    public DelegatingByTopicSerialization(Map<Pattern, T> delegates, T defaultDelegate) {
        Assert.notNull(delegates, (String)"'delegates' cannot be null");
        Assert.notNull(defaultDelegate, (String)"'defaultDelegate' cannot be null");
        this.delegates.putAll(delegates);
        delegates.keySet().forEach(pattern -> Assert.isTrue((boolean)this.patterns.add(pattern.pattern()), (String)("Duplicate pattern: " + pattern.pattern())));
        this.defaultDelegate = defaultDelegate;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.cased = caseSensitive;
    }

    protected void configure(Map<String, ?> configs, boolean isKey) {
        Object value;
        if (!this.delegates.isEmpty()) {
            this.delegates.values().forEach(delegate -> this.configureDelegate(configs, isKey, delegate));
        }
        this.forKeys = isKey;
        Object insensitive = configs.get(CASE_SENSITIVE);
        if (insensitive instanceof String) {
            String insensitiveString = (String)insensitive;
            this.cased = Boolean.parseBoolean(insensitiveString);
        } else if (insensitive instanceof Boolean) {
            Boolean insensitiveBoolean = (Boolean)insensitive;
            this.cased = insensitiveBoolean;
        }
        String configKey = this.defaultKey();
        if (configs.containsKey(configKey)) {
            this.buildDefault(configs, configKey, isKey, configs.get(configKey));
        }
        if ((value = configs.get(configKey = this.configKey())) == null) {
            return;
        }
        if (value instanceof Map) {
            this.processMap(configs, isKey, configKey, (Map)value);
        } else if (value instanceof String) {
            String mappings = (String)value;
            this.delegates.putAll(this.createDelegates(mappings, configs, isKey));
        } else {
            throw new IllegalStateException(configKey + " must be a map or String, not " + value.getClass());
        }
    }

    @NonNull
    private String defaultKey() {
        return this.forKeys ? KEY_SERIALIZATION_TOPIC_DEFAULT : VALUE_SERIALIZATION_TOPIC_DEFAULT;
    }

    private String configKey() {
        return this.forKeys ? KEY_SERIALIZATION_TOPIC_CONFIG : VALUE_SERIALIZATION_TOPIC_CONFIG;
    }

    private void processMap(Map<String, ?> configs, boolean isKey, String configKey, Map<Object, Object> value) {
        value.forEach((key, delegate) -> {
            Pattern pattern = this.obtainPattern(key);
            this.build(configs, isKey, configKey, delegate, pattern);
        });
    }

    protected void build(Map<String, ?> configs, boolean isKey, String configKey, Object delegate, Pattern pattern) {
        if (this.isInstance(delegate)) {
            if (!this.patterns.add(pattern.pattern())) {
                LOGGER.debug(() -> "Delegate already configured for " + pattern.pattern());
                return;
            }
            this.delegates.put(pattern, (Closeable)delegate);
            this.configureDelegate(configs, isKey, (Closeable)delegate);
        } else if (delegate instanceof Class) {
            Class clazz = (Class)delegate;
            this.instantiateAndConfigure(configs, isKey, this.delegates, pattern, clazz);
        } else if (delegate instanceof String) {
            String className = (String)delegate;
            this.createInstanceAndConfigure(configs, isKey, this.delegates, pattern, className);
        } else {
            throw new IllegalStateException(configKey + " map entries must be Serializers or class names, not " + delegate.getClass());
        }
    }

    protected void buildDefault(Map<String, ?> configs, String configKey, boolean isKey, Object delegate) {
        if (this.isInstance(delegate)) {
            this.defaultDelegate = this.configureDelegate(configs, isKey, (Closeable)delegate);
        } else if (delegate instanceof Class) {
            Class clazz = (Class)delegate;
            this.defaultDelegate = this.instantiateAndConfigure(configs, isKey, this.delegates, null, clazz);
        } else if (delegate instanceof String) {
            String className = (String)delegate;
            this.defaultDelegate = this.createInstanceAndConfigure(configs, isKey, this.delegates, null, className);
        } else {
            throw new IllegalStateException(configKey + " map entries must be Serializers or class names, not " + delegate.getClass());
        }
    }

    protected abstract T configureDelegate(Map<String, ?> var1, boolean var2, T var3);

    protected abstract boolean isInstance(Object var1);

    private Map<Pattern, T> createDelegates(String mappings, Map<String, ?> configs, boolean isKey) {
        String[] array;
        HashMap delegateMap = new HashMap();
        for (String entry : array = StringUtils.commaDelimitedListToStringArray((String)mappings)) {
            String[] split = entry.split(":");
            Assert.isTrue((split.length == 2 ? 1 : 0) != 0, (String)"Each comma-delimited selector entry must have exactly one ':'");
            this.createInstanceAndConfigure(configs, isKey, delegateMap, this.obtainPattern(split[0]), split[1]);
        }
        return delegateMap;
    }

    @Nullable
    private T createInstanceAndConfigure(Map<String, ?> configs, boolean isKey, Map<Pattern, T> delegates2, @Nullable Pattern pattern, String className) {
        try {
            Class clazz = ClassUtils.forName((String)className.trim(), (ClassLoader)ClassUtils.getDefaultClassLoader());
            return this.instantiateAndConfigure(configs, isKey, delegates2, pattern, clazz);
        }
        catch (ClassNotFoundException | LinkageError e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Pattern obtainPattern(Object key) {
        if (key instanceof Pattern) {
            Pattern pattern = (Pattern)key;
            return pattern;
        }
        if (key instanceof String) {
            String regex = (String)key;
            if (this.cased) {
                return Pattern.compile(regex.trim());
            }
            return Pattern.compile(regex.trim(), 2);
        }
        throw new IllegalStateException("Map key must be a Pattern or a String, not a " + key.getClass());
    }

    protected T instantiateAndConfigure(Map<String, ?> configs, boolean isKey, Map<Pattern, T> delegates2, @Nullable Pattern pattern, Class<?> clazz) {
        if (pattern != null && !this.patterns.add(pattern.pattern())) {
            LOGGER.debug(() -> "Delegate already configured for " + pattern.pattern());
            return null;
        }
        try {
            Closeable delegate = (Closeable)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.configureDelegate(configs, isKey, delegate);
            if (pattern != null) {
                delegates2.put(pattern, delegate);
            }
            return (T)delegate;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void addDelegate(Pattern pattern, T serializer) {
        this.delegates.put(pattern, serializer);
    }

    @Nullable
    public T removeDelegate(Pattern pattern) {
        return (T)((Closeable)this.delegates.remove(pattern));
    }

    protected T findDelegate(String topic) {
        Closeable delegate = null;
        for (Map.Entry<Pattern, T> entry : this.delegates.entrySet()) {
            if (!entry.getKey().matcher(topic).matches()) continue;
            delegate = (Closeable)entry.getValue();
            break;
        }
        if (delegate == null) {
            delegate = (Closeable)this.defaultDelegate;
        }
        if (delegate == null) {
            throw new IllegalStateException("No (de)serializer found for topic '" + topic + "'");
        }
        return (T)delegate;
    }

    @Override
    public void close() {
        this.delegates.values().forEach(delegate -> {
            try {
                delegate.close();
            }
            catch (IOException ex) {
                LOGGER.error((Throwable)ex, () -> "Failed to close " + delegate);
            }
        });
    }
}

