/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.Topology;
import org.springframework.kafka.config.KafkaStreamsInfrastructureCustomizer;

public class CompositeKafkaStreamsInfrastructureCustomizer
implements KafkaStreamsInfrastructureCustomizer {
    private final List<KafkaStreamsInfrastructureCustomizer> infrastructureCustomizers = new ArrayList<KafkaStreamsInfrastructureCustomizer>();

    public CompositeKafkaStreamsInfrastructureCustomizer(KafkaStreamsInfrastructureCustomizer ... customizers) {
        this.infrastructureCustomizers.addAll(Arrays.asList(customizers));
    }

    public void addKafkaStreamsCustomizers(KafkaStreamsInfrastructureCustomizer ... customizers) {
        this.infrastructureCustomizers.addAll(Arrays.asList(customizers));
    }

    @Override
    public void configureBuilder(StreamsBuilder builder) {
        this.infrastructureCustomizers.forEach(cust -> cust.configureBuilder(builder));
    }

    @Override
    public void configureTopology(Topology topology) {
        this.infrastructureCustomizers.forEach(cust -> cust.configureTopology(topology));
    }
}

