/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support.micrometer;

import io.micrometer.common.KeyValues;
import io.micrometer.common.docs.KeyName;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.docs.ObservationDocumentation;
import org.springframework.kafka.support.micrometer.KafkaRecordSenderContext;
import org.springframework.kafka.support.micrometer.KafkaTemplateObservationConvention;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum KafkaTemplateObservation implements ObservationDocumentation
{
    TEMPLATE_OBSERVATION{

        public Class<? extends ObservationConvention<? extends Observation.Context>> getDefaultConvention() {
            return DefaultKafkaTemplateObservationConvention.class;
        }

        public String getPrefix() {
            return "spring.kafka.template";
        }

        public KeyName[] getLowCardinalityKeyNames() {
            return TemplateLowCardinalityTags.values();
        }
    };


    public static class DefaultKafkaTemplateObservationConvention
    implements KafkaTemplateObservationConvention {
        public static final DefaultKafkaTemplateObservationConvention INSTANCE = new DefaultKafkaTemplateObservationConvention();

        public KeyValues getLowCardinalityKeyValues(KafkaRecordSenderContext context) {
            return KeyValues.of((String)TemplateLowCardinalityTags.BEAN_NAME.asString(), (String)context.getBeanName());
        }

        public String getContextualName(KafkaRecordSenderContext context) {
            return context.getDestination() + " send";
        }

        @Override
        public String getName() {
            return "spring.kafka.template";
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum TemplateLowCardinalityTags implements KeyName
    {
        BEAN_NAME{

            public String asString() {
                return "spring.kafka.template.name";
            }
        };

    }
}

