/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.security.jaas;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.util.Assert;

public class KafkaJaasLoginModuleInitializer
implements SmartInitializingSingleton,
DisposableBean {
    public static final String KAFKA_CLIENT_CONTEXT_NAME = "KafkaClient";
    private final boolean ignoreJavaLoginConfigParamSystemProperty;
    private final File placeholderJaasConfiguration;
    private final Map<String, String> options = new HashMap<String, String>();
    private String loginModule = "com.sun.security.auth.module.Krb5LoginModule";
    private AppConfigurationEntry.LoginModuleControlFlag controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;

    public KafkaJaasLoginModuleInitializer() throws IOException {
        this.ignoreJavaLoginConfigParamSystemProperty = System.getProperty("java.security.auth.login.config") == null;
        this.placeholderJaasConfiguration = File.createTempFile("kafka-client-jaas-config-placeholder", "conf");
        this.placeholderJaasConfiguration.deleteOnExit();
    }

    public void setLoginModule(String loginModule) {
        Assert.notNull((Object)loginModule, (String)"cannot be null");
        this.loginModule = loginModule;
    }

    public void setControlFlag(ControlFlag controlFlag) {
        Assert.notNull((Object)((Object)controlFlag), (String)"cannot be null");
        switch (controlFlag) {
            case OPTIONAL: {
                this.controlFlag = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
                break;
            }
            case REQUIRED: {
                this.controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
                break;
            }
            case REQUISITE: {
                this.controlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
                break;
            }
            case SUFFICIENT: {
                this.controlFlag = AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
                break;
            }
            default: {
                throw new IllegalArgumentException(controlFlag + " is not a supported control flag");
            }
        }
    }

    public void setOptions(Map<String, String> options) {
        this.options.clear();
        this.options.putAll(options);
    }

    public void afterSingletonsInstantiated() {
        if (this.ignoreJavaLoginConfigParamSystemProperty) {
            HashMap<String, AppConfigurationEntry[]> configurationEntries = new HashMap<String, AppConfigurationEntry[]>();
            AppConfigurationEntry kafkaClientConfigurationEntry = new AppConfigurationEntry(this.loginModule, this.controlFlag, this.options);
            configurationEntries.put(KAFKA_CLIENT_CONTEXT_NAME, new AppConfigurationEntry[]{kafkaClientConfigurationEntry});
            Configuration.setConfiguration(new InternalConfiguration(configurationEntries));
            if (this.placeholderJaasConfiguration != null) {
                System.setProperty("java.security.auth.login.config", this.placeholderJaasConfiguration.getAbsolutePath());
            }
        }
    }

    public void destroy() {
        if (this.ignoreJavaLoginConfigParamSystemProperty) {
            System.clearProperty("java.security.auth.login.config");
        }
    }

    public static enum ControlFlag {
        REQUIRED,
        REQUISITE,
        SUFFICIENT,
        OPTIONAL;

    }

    private static class InternalConfiguration
    extends Configuration {
        private final Map<String, AppConfigurationEntry[]> configurationEntries;

        InternalConfiguration(Map<String, AppConfigurationEntry[]> configurationEntries) {
            Assert.notNull(configurationEntries, (String)" cannot be null");
            Assert.notEmpty(configurationEntries, (String)" cannot be empty");
            this.configurationEntries = configurationEntries;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            return this.configurationEntries.get(name);
        }
    }
}

