/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.retrytopic;

import java.util.ArrayList;
import java.util.List;
import org.springframework.classify.BinaryExceptionClassifier;
import org.springframework.classify.BinaryExceptionClassifierBuilder;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.core.KafkaOperations;
import org.springframework.kafka.retrytopic.BackOffValuesGenerator;
import org.springframework.kafka.retrytopic.DestinationTopic;
import org.springframework.kafka.retrytopic.DestinationTopicPropertiesFactory;
import org.springframework.kafka.retrytopic.DltStrategy;
import org.springframework.kafka.retrytopic.FixedDelayStrategy;
import org.springframework.kafka.retrytopic.ListenerContainerFactoryConfigurer;
import org.springframework.kafka.retrytopic.ListenerContainerFactoryResolver;
import org.springframework.kafka.retrytopic.RetryTopicConfiguration;
import org.springframework.kafka.retrytopic.RetryTopicConfigurer;
import org.springframework.kafka.retrytopic.TopicSuffixingStrategy;
import org.springframework.kafka.support.AllowDenyCollectionManager;
import org.springframework.kafka.support.EndpointHandlerMethod;
import org.springframework.lang.Nullable;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.ExponentialBackOffPolicy;
import org.springframework.retry.backoff.ExponentialRandomBackOffPolicy;
import org.springframework.retry.backoff.FixedBackOffPolicy;
import org.springframework.retry.backoff.NoBackOffPolicy;
import org.springframework.retry.backoff.SleepingBackOffPolicy;
import org.springframework.retry.backoff.UniformRandomBackOffPolicy;
import org.springframework.util.Assert;

public class RetryTopicConfigurationBuilder {
    private static final String ALREADY_SELECTED = "You have already selected backoff policy";
    private final List<String> includeTopicNames = new ArrayList<String>();
    private final List<String> excludeTopicNames = new ArrayList<String>();
    private int maxAttempts = -1;
    private BackOffPolicy backOffPolicy;
    private EndpointHandlerMethod dltHandlerMethod;
    private String retryTopicSuffix;
    private String dltSuffix;
    private RetryTopicConfiguration.TopicCreation topicCreationConfiguration = new RetryTopicConfiguration.TopicCreation();
    private ConcurrentKafkaListenerContainerFactory<?, ?> listenerContainerFactory;
    private String listenerContainerFactoryName;
    private BinaryExceptionClassifierBuilder classifierBuilder;
    private FixedDelayStrategy fixedDelayStrategy = FixedDelayStrategy.MULTIPLE_TOPICS;
    private DltStrategy dltStrategy = DltStrategy.ALWAYS_RETRY_ON_ERROR;
    private long timeout = -1L;
    private TopicSuffixingStrategy topicSuffixingStrategy = TopicSuffixingStrategy.SUFFIX_WITH_DELAY_VALUE;
    private Boolean autoStartDltHandler;

    public RetryTopicConfigurationBuilder dltHandlerMethod(String beanName, String methodName) {
        this.dltHandlerMethod = RetryTopicConfigurer.createHandlerMethodWith((Object)beanName, methodName);
        return this;
    }

    public RetryTopicConfigurationBuilder dltHandlerMethod(EndpointHandlerMethod endpointHandlerMethod) {
        this.dltHandlerMethod = endpointHandlerMethod;
        return this;
    }

    public RetryTopicConfigurationBuilder doNotRetryOnDltFailure() {
        this.dltStrategy = DltStrategy.FAIL_ON_ERROR;
        return this;
    }

    public RetryTopicConfigurationBuilder dltProcessingFailureStrategy(DltStrategy dltStrategy) {
        this.dltStrategy = dltStrategy;
        return this;
    }

    public RetryTopicConfigurationBuilder doNotConfigureDlt() {
        this.dltStrategy = DltStrategy.NO_DLT;
        return this;
    }

    public RetryTopicConfigurationBuilder autoStartDltHandler(@Nullable Boolean autoStart) {
        this.autoStartDltHandler = autoStart;
        return this;
    }

    public RetryTopicConfigurationBuilder includeTopics(List<String> topicNames) {
        this.includeTopicNames.addAll(topicNames);
        return this;
    }

    public RetryTopicConfigurationBuilder excludeTopics(List<String> topicNames) {
        this.excludeTopicNames.addAll(topicNames);
        return this;
    }

    public RetryTopicConfigurationBuilder includeTopic(String topicName) {
        this.includeTopicNames.add(topicName);
        return this;
    }

    public RetryTopicConfigurationBuilder excludeTopic(String topicName) {
        this.excludeTopicNames.add(topicName);
        return this;
    }

    public RetryTopicConfigurationBuilder retryTopicSuffix(String suffix) {
        this.retryTopicSuffix = suffix;
        return this;
    }

    public RetryTopicConfigurationBuilder dltSuffix(String suffix) {
        this.dltSuffix = suffix;
        return this;
    }

    public RetryTopicConfigurationBuilder suffixTopicsWithIndexValues() {
        this.topicSuffixingStrategy = TopicSuffixingStrategy.SUFFIX_WITH_INDEX_VALUE;
        return this;
    }

    public RetryTopicConfigurationBuilder setTopicSuffixingStrategy(TopicSuffixingStrategy topicSuffixingStrategy) {
        this.topicSuffixingStrategy = topicSuffixingStrategy;
        return this;
    }

    public RetryTopicConfigurationBuilder maxAttempts(int maxAttempts) {
        Assert.isTrue((maxAttempts > 0 ? 1 : 0) != 0, (String)"Number of attempts should be positive");
        Assert.isTrue((this.maxAttempts == -1 ? 1 : 0) != 0, (String)"You have already set the number of attempts");
        this.maxAttempts = maxAttempts;
        return this;
    }

    public RetryTopicConfigurationBuilder timeoutAfter(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public RetryTopicConfigurationBuilder exponentialBackoff(long initialInterval, double multiplier, long maxInterval) {
        return this.exponentialBackoff(initialInterval, multiplier, maxInterval, false);
    }

    public RetryTopicConfigurationBuilder exponentialBackoff(long initialInterval, double multiplier, long maxInterval, boolean withRandom) {
        Assert.isNull((Object)this.backOffPolicy, (String)ALREADY_SELECTED);
        Assert.isTrue((initialInterval >= 1L ? 1 : 0) != 0, (String)"Initial interval should be >= 1");
        Assert.isTrue((multiplier > 1.0 ? 1 : 0) != 0, (String)"Multiplier should be > 1");
        Assert.isTrue((maxInterval > initialInterval ? 1 : 0) != 0, (String)"Max interval should be > than initial interval");
        ExponentialRandomBackOffPolicy policy = withRandom ? new ExponentialRandomBackOffPolicy() : new ExponentialBackOffPolicy();
        policy.setInitialInterval(initialInterval);
        policy.setMultiplier(multiplier);
        policy.setMaxInterval(maxInterval);
        this.backOffPolicy = policy;
        return this;
    }

    public RetryTopicConfigurationBuilder fixedBackOff(long interval) {
        Assert.isNull((Object)this.backOffPolicy, (String)ALREADY_SELECTED);
        Assert.isTrue((interval >= 1L ? 1 : 0) != 0, (String)"Interval should be >= 1");
        FixedBackOffPolicy policy = new FixedBackOffPolicy();
        policy.setBackOffPeriod(interval);
        this.backOffPolicy = policy;
        return this;
    }

    public RetryTopicConfigurationBuilder uniformRandomBackoff(long minInterval, long maxInterval) {
        Assert.isNull((Object)this.backOffPolicy, (String)ALREADY_SELECTED);
        Assert.isTrue((minInterval >= 1L ? 1 : 0) != 0, (String)"Min interval should be >= 1");
        Assert.isTrue((maxInterval >= 1L ? 1 : 0) != 0, (String)"Max interval should be >= 1");
        Assert.isTrue((maxInterval > minInterval ? 1 : 0) != 0, (String)"Max interval should be > than min interval");
        UniformRandomBackOffPolicy policy = new UniformRandomBackOffPolicy();
        policy.setMinBackOffPeriod(minInterval);
        policy.setMaxBackOffPeriod(maxInterval);
        this.backOffPolicy = policy;
        return this;
    }

    public RetryTopicConfigurationBuilder noBackoff() {
        Assert.isNull((Object)this.backOffPolicy, (String)ALREADY_SELECTED);
        this.backOffPolicy = new NoBackOffPolicy();
        return this;
    }

    public RetryTopicConfigurationBuilder customBackoff(SleepingBackOffPolicy<?> backOffPolicy) {
        Assert.isNull((Object)this.backOffPolicy, (String)ALREADY_SELECTED);
        Assert.notNull(backOffPolicy, (String)"You should provide non null custom policy");
        this.backOffPolicy = backOffPolicy;
        return this;
    }

    public RetryTopicConfigurationBuilder fixedBackOff(int interval) {
        FixedBackOffPolicy policy = new FixedBackOffPolicy();
        policy.setBackOffPeriod((long)interval);
        this.backOffPolicy = policy;
        return this;
    }

    public RetryTopicConfigurationBuilder useSingleTopicForFixedDelays() {
        this.fixedDelayStrategy = FixedDelayStrategy.SINGLE_TOPIC;
        return this;
    }

    public RetryTopicConfigurationBuilder useSingleTopicForFixedDelays(FixedDelayStrategy useSameTopicForFixedDelays) {
        this.fixedDelayStrategy = useSameTopicForFixedDelays;
        return this;
    }

    public RetryTopicConfigurationBuilder doNotAutoCreateRetryTopics() {
        this.topicCreationConfiguration = new RetryTopicConfiguration.TopicCreation(false);
        return this;
    }

    public RetryTopicConfigurationBuilder autoCreateTopicsWith(int numPartitions, short replicationFactor) {
        this.topicCreationConfiguration = new RetryTopicConfiguration.TopicCreation(true, numPartitions, replicationFactor);
        return this;
    }

    public RetryTopicConfigurationBuilder autoCreateTopics(boolean shouldCreate, int numPartitions, short replicationFactor) {
        this.topicCreationConfiguration = new RetryTopicConfiguration.TopicCreation(shouldCreate, numPartitions, replicationFactor);
        return this;
    }

    public RetryTopicConfigurationBuilder retryOn(Class<? extends Throwable> throwable) {
        this.classifierBuilder().retryOn(throwable);
        return this;
    }

    public RetryTopicConfigurationBuilder notRetryOn(Class<? extends Throwable> throwable) {
        this.classifierBuilder().notRetryOn(throwable);
        return this;
    }

    public RetryTopicConfigurationBuilder retryOn(List<Class<? extends Throwable>> throwables) {
        throwables.stream().forEach(throwable -> this.classifierBuilder().retryOn(throwable));
        return this;
    }

    public RetryTopicConfigurationBuilder notRetryOn(List<Class<? extends Throwable>> throwables) {
        throwables.stream().forEach(throwable -> this.classifierBuilder().notRetryOn(throwable));
        return this;
    }

    public RetryTopicConfigurationBuilder traversingCauses() {
        this.classifierBuilder().traversingCauses();
        return this;
    }

    public RetryTopicConfigurationBuilder traversingCauses(boolean traversing) {
        if (traversing) {
            this.classifierBuilder().traversingCauses();
        }
        return this;
    }

    private BinaryExceptionClassifierBuilder classifierBuilder() {
        if (this.classifierBuilder == null) {
            this.classifierBuilder = new BinaryExceptionClassifierBuilder();
        }
        return this.classifierBuilder;
    }

    public RetryTopicConfigurationBuilder listenerFactory(ConcurrentKafkaListenerContainerFactory<?, ?> factory) {
        this.listenerContainerFactory = factory;
        return this;
    }

    public RetryTopicConfigurationBuilder listenerFactory(String factoryBeanName) {
        this.listenerContainerFactoryName = factoryBeanName;
        return this;
    }

    public RetryTopicConfiguration create(KafkaOperations<?, ?> sendToTopicKafkaTemplate) {
        ListenerContainerFactoryResolver.Configuration factoryResolverConfig = new ListenerContainerFactoryResolver.Configuration(this.listenerContainerFactory, this.listenerContainerFactoryName);
        AllowDenyCollectionManager<String> allowListManager = new AllowDenyCollectionManager<String>(this.includeTopicNames, this.excludeTopicNames);
        List<Long> backOffValues = new BackOffValuesGenerator(this.maxAttempts, this.backOffPolicy).generateValues();
        ListenerContainerFactoryConfigurer.Configuration factoryConfigurerConfig = new ListenerContainerFactoryConfigurer.Configuration(backOffValues);
        List<DestinationTopic.Properties> destinationTopicProperties = new DestinationTopicPropertiesFactory(this.retryTopicSuffix, this.dltSuffix, backOffValues, this.buildClassifier(), this.topicCreationConfiguration.getNumPartitions(), sendToTopicKafkaTemplate, this.fixedDelayStrategy, this.dltStrategy, this.topicSuffixingStrategy, this.timeout).autoStartDltHandler(this.autoStartDltHandler).createProperties();
        return new RetryTopicConfiguration(destinationTopicProperties, this.dltHandlerMethod, this.topicCreationConfiguration, allowListManager, factoryResolverConfig, factoryConfigurerConfig);
    }

    private BinaryExceptionClassifier buildClassifier() {
        return this.classifierBuilder != null ? this.classifierBuilder.build() : new BinaryExceptionClassifierBuilder().retryOn(Throwable.class).build();
    }

    public static RetryTopicConfigurationBuilder newInstance() {
        return new RetryTopicConfigurationBuilder();
    }
}

