/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.retrytopic;

import java.time.Clock;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.kafka.listener.KafkaBackOffManagerFactory;
import org.springframework.kafka.listener.KafkaConsumerBackoffManager;
import org.springframework.kafka.listener.ListenerContainerRegistry;
import org.springframework.kafka.listener.PartitionPausingBackOffManagerFactory;
import org.springframework.kafka.retrytopic.DeadLetterPublishingRecovererFactory;
import org.springframework.kafka.retrytopic.DefaultDestinationTopicProcessor;
import org.springframework.kafka.retrytopic.DefaultDestinationTopicResolver;
import org.springframework.kafka.retrytopic.DestinationTopicProcessor;
import org.springframework.kafka.retrytopic.DestinationTopicResolver;
import org.springframework.kafka.retrytopic.ListenerContainerFactoryConfigurer;
import org.springframework.kafka.retrytopic.ListenerContainerFactoryResolver;
import org.springframework.kafka.retrytopic.RetryTopicConfigurer;
import org.springframework.kafka.retrytopic.RetryTopicNamesProviderFactory;
import org.springframework.kafka.retrytopic.SuffixingRetryTopicNamesProviderFactory;

public class RetryTopicComponentFactory {
    private final Clock internalRetryTopicClock = this.createInternalRetryTopicClock();

    public RetryTopicConfigurer retryTopicConfigurer(DestinationTopicProcessor destinationTopicProcessor, ListenerContainerFactoryConfigurer listenerContainerFactoryConfigurer, ListenerContainerFactoryResolver factoryResolver, RetryTopicNamesProviderFactory retryTopicNamesProviderFactory) {
        return new RetryTopicConfigurer(destinationTopicProcessor, factoryResolver, listenerContainerFactoryConfigurer, retryTopicNamesProviderFactory);
    }

    public DestinationTopicProcessor destinationTopicProcessor(DestinationTopicResolver destinationTopicResolver) {
        return new DefaultDestinationTopicProcessor(destinationTopicResolver);
    }

    public DestinationTopicResolver destinationTopicResolver() {
        return new DefaultDestinationTopicResolver(this.internalRetryTopicClock);
    }

    public DeadLetterPublishingRecovererFactory deadLetterPublishingRecovererFactory(DestinationTopicResolver destinationTopicResolver) {
        return new DeadLetterPublishingRecovererFactory(destinationTopicResolver);
    }

    public ListenerContainerFactoryResolver listenerContainerFactoryResolver(BeanFactory beanFactory) {
        return new ListenerContainerFactoryResolver(beanFactory);
    }

    public ListenerContainerFactoryConfigurer listenerContainerFactoryConfigurer(KafkaConsumerBackoffManager kafkaConsumerBackoffManager, DeadLetterPublishingRecovererFactory deadLetterPublishingRecovererFactory, Clock clock) {
        return new ListenerContainerFactoryConfigurer(kafkaConsumerBackoffManager, deadLetterPublishingRecovererFactory, clock);
    }

    public RetryTopicNamesProviderFactory retryTopicNamesProviderFactory() {
        return new SuffixingRetryTopicNamesProviderFactory();
    }

    public KafkaBackOffManagerFactory kafkaBackOffManagerFactory(ListenerContainerRegistry registry) {
        return new PartitionPausingBackOffManagerFactory(registry);
    }

    public Clock internalRetryTopicClock() {
        return this.internalRetryTopicClock;
    }

    protected Clock createInternalRetryTopicClock() {
        return Clock.systemUTC();
    }
}

