/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.retrytopic;

import java.time.Clock;
import java.util.function.Supplier;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.SingletonBeanRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.task.TaskExecutor;
import org.springframework.kafka.listener.KafkaBackOffManagerFactory;
import org.springframework.kafka.listener.KafkaConsumerBackoffManager;
import org.springframework.kafka.listener.KafkaConsumerTimingAdjuster;
import org.springframework.kafka.listener.PartitionPausingBackOffManagerFactory;
import org.springframework.kafka.listener.PartitionPausingBackoffManager;
import org.springframework.kafka.retrytopic.DeadLetterPublishingRecovererFactory;
import org.springframework.kafka.retrytopic.DefaultDestinationTopicProcessor;
import org.springframework.kafka.retrytopic.DefaultDestinationTopicResolver;
import org.springframework.kafka.retrytopic.ListenerContainerFactoryConfigurer;
import org.springframework.kafka.retrytopic.ListenerContainerFactoryResolver;
import org.springframework.kafka.retrytopic.RetryTopicConfigurer;
import org.springframework.kafka.retrytopic.RetryTopicNamesProviderFactory;
import org.springframework.kafka.retrytopic.SuffixingRetryTopicNamesProviderFactory;
import org.springframework.retry.backoff.ThreadWaitSleeper;

@Deprecated
public class RetryTopicBootstrapper {
    private final ApplicationContext applicationContext;
    private final BeanFactory beanFactory;

    public RetryTopicBootstrapper(ApplicationContext applicationContext, BeanFactory beanFactory) {
        if (!ConfigurableApplicationContext.class.isAssignableFrom(applicationContext.getClass()) || !BeanDefinitionRegistry.class.isAssignableFrom(applicationContext.getClass())) {
            throw new IllegalStateException(String.format("ApplicationContext must be implement %s and %s interfaces. Provided: %s", ConfigurableApplicationContext.class.getSimpleName(), BeanDefinitionRegistry.class.getSimpleName(), applicationContext.getClass().getSimpleName()));
        }
        if (!SingletonBeanRegistry.class.isAssignableFrom(beanFactory.getClass())) {
            throw new IllegalStateException("BeanFactory must implement " + SingletonBeanRegistry.class + " interface. Provided: " + beanFactory.getClass().getSimpleName());
        }
        this.beanFactory = beanFactory;
        this.applicationContext = applicationContext;
    }

    public void bootstrapRetryTopic() {
        this.registerBeans();
        this.registerSingletons();
        this.addApplicationListeners();
    }

    private void registerBeans() {
        this.registerIfNotContains("internalListenerContainerFactoryResolver", ListenerContainerFactoryResolver.class);
        this.registerIfNotContains("internalDestinationTopicProcessor", DefaultDestinationTopicProcessor.class);
        this.registerIfNotContains("internalListenerContainerFactoryConfigurer", ListenerContainerFactoryConfigurer.class);
        this.registerIfNotContains("internalDeadLetterPublishingRecovererProvider", DeadLetterPublishingRecovererFactory.class);
        this.registerIfNotContains("internalRetryTopicConfigurer", RetryTopicConfigurer.class);
        this.registerIfNotContains("internalDestinationTopicContainer", DefaultDestinationTopicResolver.class);
        this.registerIfNotContains("internalBackoffSleeper", ThreadWaitSleeper.class);
        this.registerIfNotContains("internalKafkaConsumerBackOffManagerFactory", PartitionPausingBackOffManagerFactory.class);
        try {
            this.applicationContext.getBean(RetryTopicNamesProviderFactory.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            ((BeanDefinitionRegistry)this.applicationContext).registerBeanDefinition("internalRetryTopicNamesProviderFactory", (BeanDefinition)new RootBeanDefinition(SuffixingRetryTopicNamesProviderFactory.class));
        }
    }

    private void registerSingletons() {
        this.registerSingletonIfNotContains("internalBackOffClock", Clock::systemUTC);
        this.registerSingletonIfNotContains("internalKafkaConsumerBackoffManager", this::createKafkaConsumerBackoffManager);
    }

    private void addApplicationListeners() {
        ConfigurableApplicationContext context = (ConfigurableApplicationContext)this.applicationContext;
        context.addApplicationListener((ApplicationListener)this.applicationContext.getBean("internalDestinationTopicContainer", DefaultDestinationTopicResolver.class));
        context.addApplicationListener((ApplicationListener)this.applicationContext.getBean("internalKafkaConsumerBackoffManager", PartitionPausingBackoffManager.class));
    }

    private KafkaConsumerBackoffManager createKafkaConsumerBackoffManager() {
        KafkaBackOffManagerFactory factory = (KafkaBackOffManagerFactory)this.applicationContext.getBean("internalKafkaConsumerBackOffManagerFactory", KafkaBackOffManagerFactory.class);
        if (ApplicationContextAware.class.isAssignableFrom(factory.getClass())) {
            ((ApplicationContextAware)factory).setApplicationContext(this.applicationContext);
        }
        if (PartitionPausingBackOffManagerFactory.class.isAssignableFrom(factory.getClass())) {
            this.setupTimingAdjustingBackOffFactory((PartitionPausingBackOffManagerFactory)factory);
        }
        return factory.create();
    }

    private void setupTimingAdjustingBackOffFactory(PartitionPausingBackOffManagerFactory factory) {
        if (this.applicationContext.containsBean("internalBackOffTaskExecutor")) {
            factory.setTaskExecutor((TaskExecutor)this.applicationContext.getBean("internalBackOffTaskExecutor", TaskExecutor.class));
        }
        if (this.applicationContext.containsBean("internalKafkaConsumerTimingAdjustmentManager")) {
            factory.setTimingAdjustmentManager((KafkaConsumerTimingAdjuster)this.applicationContext.getBean("internalKafkaConsumerTimingAdjustmentManager", KafkaConsumerTimingAdjuster.class));
        }
    }

    private void registerIfNotContains(String beanName, Class<?> beanClass) {
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)this.applicationContext;
        if (!registry.containsBeanDefinition(beanName)) {
            registry.registerBeanDefinition(beanName, (BeanDefinition)new RootBeanDefinition(beanClass));
        }
    }

    private void registerSingletonIfNotContains(String beanName, Supplier<Object> singletonSupplier) {
        if (!this.applicationContext.containsBeanDefinition(beanName)) {
            ((SingletonBeanRegistry)this.beanFactory).registerSingleton(beanName, singletonSupplier.get());
        }
    }
}

