/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener.adapter;

import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.kafka.listener.AcknowledgingConsumerAwareMessageListener;
import org.springframework.kafka.listener.MessageListener;
import org.springframework.kafka.listener.adapter.AbstractRetryingMessageListenerAdapter;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.lang.Nullable;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.RetryState;
import org.springframework.retry.support.DefaultRetryState;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;

@Deprecated
public class RetryingMessageListenerAdapter<K, V>
extends AbstractRetryingMessageListenerAdapter<K, V, MessageListener<K, V>>
implements AcknowledgingConsumerAwareMessageListener<K, V> {
    public static final String CONTEXT_ACKNOWLEDGMENT = "acknowledgment";
    public static final String CONTEXT_CONSUMER = "consumer";
    public static final String CONTEXT_RECORD = "record";
    private boolean stateful;

    public RetryingMessageListenerAdapter(MessageListener<K, V> messageListener, RetryTemplate retryTemplate) {
        this(messageListener, retryTemplate, (RecoveryCallback<Object>)null);
    }

    public RetryingMessageListenerAdapter(MessageListener<K, V> messageListener, RetryTemplate retryTemplate, @Nullable RecoveryCallback<? extends Object> recoveryCallback) {
        this(messageListener, retryTemplate, recoveryCallback, false);
    }

    public RetryingMessageListenerAdapter(MessageListener<K, V> messageListener, RetryTemplate retryTemplate, @Nullable RecoveryCallback<? extends Object> recoveryCallback, boolean stateful) {
        super(messageListener, retryTemplate, recoveryCallback);
        Assert.notNull(messageListener, (String)"'messageListener' cannot be null");
        this.stateful = stateful;
    }

    @Override
    public void onMessage(ConsumerRecord<K, V> record, @Nullable Acknowledgment acknowledgment, Consumer<?, ?> consumer) {
        DefaultRetryState retryState = null;
        if (this.stateful) {
            retryState = new DefaultRetryState((Object)(record.topic() + "-" + record.partition() + "-" + record.offset()));
        }
        this.getRetryTemplate().execute(context -> {
            context.setAttribute(CONTEXT_RECORD, (Object)record);
            switch (this.delegateType) {
                case ACKNOWLEDGING_CONSUMER_AWARE: {
                    context.setAttribute(CONTEXT_ACKNOWLEDGMENT, (Object)acknowledgment);
                    context.setAttribute(CONTEXT_CONSUMER, (Object)consumer);
                    ((MessageListener)this.delegate).onMessage(record, acknowledgment, consumer);
                    break;
                }
                case ACKNOWLEDGING: {
                    context.setAttribute(CONTEXT_ACKNOWLEDGMENT, (Object)acknowledgment);
                    ((MessageListener)this.delegate).onMessage(record, acknowledgment);
                    break;
                }
                case CONSUMER_AWARE: {
                    context.setAttribute(CONTEXT_CONSUMER, (Object)consumer);
                    ((MessageListener)this.delegate).onMessage(record, consumer);
                    break;
                }
                case SIMPLE: {
                    ((MessageListener)this.delegate).onMessage(record);
                }
            }
            return null;
        }, this.getRecoveryCallback(), (RetryState)retryState);
    }

    @Override
    public void onMessage(ConsumerRecord<K, V> data) {
        this.onMessage(data, (Acknowledgment)null, (Consumer<?, ?>)null);
    }

    @Override
    public void onMessage(ConsumerRecord<K, V> data, Acknowledgment acknowledgment) {
        this.onMessage(data, acknowledgment, (Consumer<?, ?>)null);
    }

    @Override
    public void onMessage(ConsumerRecord<K, V> data, Consumer<?, ?> consumer) {
        this.onMessage(data, (Acknowledgment)null, consumer);
    }
}

