/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.time.Clock;
import org.springframework.core.task.TaskExecutor;
import org.springframework.kafka.listener.AbstractKafkaBackOffManagerFactory;
import org.springframework.kafka.listener.KafkaConsumerBackoffManager;
import org.springframework.kafka.listener.KafkaConsumerTimingAdjuster;
import org.springframework.kafka.listener.ListenerContainerRegistry;
import org.springframework.kafka.listener.PartitionPausingBackoffManager;
import org.springframework.kafka.listener.WakingKafkaConsumerTimingAdjuster;
import org.springframework.util.Assert;

public class PartitionPausingBackOffManagerFactory
extends AbstractKafkaBackOffManagerFactory {
    private boolean timingAdjustmentEnabled = true;
    private KafkaConsumerTimingAdjuster timingAdjustmentManager;
    private TaskExecutor taskExecutor;
    private Clock clock;

    public PartitionPausingBackOffManagerFactory(KafkaConsumerTimingAdjuster timingAdjustmentManager) {
        this.clock = this.getDefaultClock();
        this.setTimingAdjustmentManager(timingAdjustmentManager);
    }

    public PartitionPausingBackOffManagerFactory(TaskExecutor timingAdjustmentManagerTaskExecutor) {
        this.clock = this.getDefaultClock();
        this.setTaskExecutor(timingAdjustmentManagerTaskExecutor);
    }

    public PartitionPausingBackOffManagerFactory(boolean timingAdjustmentEnabled) {
        this.clock = this.getDefaultClock();
        this.setTimingAdjustmentEnabled(timingAdjustmentEnabled);
    }

    public PartitionPausingBackOffManagerFactory(ListenerContainerRegistry listenerContainerRegistry) {
        super(listenerContainerRegistry);
        this.clock = this.getDefaultClock();
    }

    public PartitionPausingBackOffManagerFactory() {
        this.clock = this.getDefaultClock();
    }

    public PartitionPausingBackOffManagerFactory(Clock clock) {
        this.clock = clock;
    }

    public void setTimingAdjustmentEnabled(boolean timingAdjustmentEnabled) {
        this.timingAdjustmentEnabled = timingAdjustmentEnabled;
    }

    public void setTimingAdjustmentManager(KafkaConsumerTimingAdjuster timingAdjustmentManager) {
        Assert.isTrue((boolean)this.timingAdjustmentEnabled, () -> "TimingAdjustment is disabled for this factory.");
        this.timingAdjustmentManager = timingAdjustmentManager;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        Assert.isTrue((boolean)this.timingAdjustmentEnabled, () -> "TimingAdjustment is disabled for this factory.");
        this.taskExecutor = taskExecutor;
    }

    public void setClock(Clock clock) {
        this.clock = clock;
    }

    @Override
    protected KafkaConsumerBackoffManager doCreateManager(ListenerContainerRegistry registry) {
        return this.getKafkaConsumerBackoffManager(registry);
    }

    protected final Clock getDefaultClock() {
        return Clock.systemUTC();
    }

    private PartitionPausingBackoffManager getKafkaConsumerBackoffManager(ListenerContainerRegistry registry) {
        return this.timingAdjustmentEnabled && this.taskExecutor != null ? new PartitionPausingBackoffManager(registry, this.getOrCreateBackOffTimingAdjustmentManager(), this.clock) : new PartitionPausingBackoffManager(registry, this.clock);
    }

    private KafkaConsumerTimingAdjuster getOrCreateBackOffTimingAdjustmentManager() {
        if (this.timingAdjustmentManager != null) {
            return this.timingAdjustmentManager;
        }
        return new WakingKafkaConsumerTimingAdjuster(this.taskExecutor);
    }
}

