/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdNodeBasedDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeader;
import org.springframework.kafka.support.AbstractKafkaHeaderMapper;
import org.springframework.lang.Nullable;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MimeType;

public class DefaultKafkaHeaderMapper
extends AbstractKafkaHeaderMapper {
    private static final List<String> DEFAULT_TRUSTED_PACKAGES = Arrays.asList("java.lang", "java.net", "java.util", "org.springframework.util");
    private static final List<String> DEFAULT_TO_STRING_CLASSES = Arrays.asList("org.springframework.util.MimeType", "org.springframework.http.MediaType");
    public static final String JSON_TYPES = "spring_json_header_types";
    private final ObjectMapper objectMapper;
    private final Set<String> trustedPackages = new LinkedHashSet<String>(DEFAULT_TRUSTED_PACKAGES);
    private final Set<String> toStringClasses = new LinkedHashSet<String>(DEFAULT_TO_STRING_CLASSES);

    public DefaultKafkaHeaderMapper() {
        this(new ObjectMapper());
    }

    public DefaultKafkaHeaderMapper(ObjectMapper objectMapper) {
        this(objectMapper, "!id", "!timestamp", "*");
    }

    public DefaultKafkaHeaderMapper(String ... patterns) {
        this(new ObjectMapper(), patterns);
    }

    public DefaultKafkaHeaderMapper(ObjectMapper objectMapper, String ... patterns) {
        super(patterns);
        Assert.notNull((Object)objectMapper, (String)"'objectMapper' must not be null");
        Assert.noNullElements((Object[])patterns, (String)"'patterns' must not have null elements");
        this.objectMapper = objectMapper;
        this.objectMapper.registerModule((Module)new SimpleModule().addDeserializer(MimeType.class, (JsonDeserializer)new MimeTypeJsonDeserializer()));
    }

    protected ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    protected Set<String> getTrustedPackages() {
        return this.trustedPackages;
    }

    protected Set<String> getToStringClasses() {
        return this.toStringClasses;
    }

    public void addTrustedPackages(String ... packagesToTrust) {
        if (packagesToTrust != null) {
            for (String whiteList : packagesToTrust) {
                if ("*".equals(whiteList)) {
                    this.trustedPackages.clear();
                    break;
                }
                this.trustedPackages.add(whiteList);
            }
        }
    }

    public void addToStringClasses(String ... classNames) {
        this.toStringClasses.addAll(Arrays.asList(classNames));
    }

    @Override
    public void fromHeaders(MessageHeaders headers, Headers target) {
        HashMap jsonHeaders = new HashMap();
        ObjectMapper headerObjectMapper = this.getObjectMapper();
        headers.forEach((key, val) -> {
            block6: {
                if (this.matches((String)key, val)) {
                    Object valueToAdd = this.headerValueToAddOut((String)key, val);
                    if (valueToAdd instanceof byte[]) {
                        target.add((Header)new RecordHeader(key, (byte[])valueToAdd));
                    } else {
                        try {
                            Object value = valueToAdd;
                            String className = valueToAdd.getClass().getName();
                            if (this.toStringClasses.contains(className)) {
                                value = valueToAdd.toString();
                                className = "java.lang.String";
                            }
                            target.add((Header)new RecordHeader(key, headerObjectMapper.writeValueAsBytes(value)));
                            jsonHeaders.put(key, className);
                        }
                        catch (Exception e) {
                            if (!this.logger.isDebugEnabled()) break block6;
                            this.logger.debug((Object)("Could not map " + key + " with type " + valueToAdd.getClass().getName()));
                        }
                    }
                }
            }
        });
        if (jsonHeaders.size() > 0) {
            try {
                target.add((Header)new RecordHeader(JSON_TYPES, headerObjectMapper.writeValueAsBytes(jsonHeaders)));
            }
            catch (JsonProcessingException | IllegalStateException e) {
                this.logger.error((Object)"Could not add json types header", e);
            }
        }
    }

    @Override
    public void toHeaders(Headers source, Map<String, Object> headers) {
        Map<String, String> jsonTypes = this.decodeJsonTypes(source);
        source.forEach(header -> {
            if (!header.key().equals(JSON_TYPES)) {
                if (jsonTypes != null && jsonTypes.containsKey(header.key())) {
                    Class type = Object.class;
                    String requestedType = (String)jsonTypes.get(header.key());
                    boolean trusted = false;
                    try {
                        trusted = this.trusted(requestedType);
                        if (trusted) {
                            type = ClassUtils.forName((String)requestedType, null);
                        }
                    }
                    catch (Exception e) {
                        this.logger.error((Object)("Could not load class for header: " + header.key()), (Throwable)e);
                    }
                    if (trusted) {
                        try {
                            Object value = this.decodeValue((Header)header, type);
                            headers.put(header.key(), value);
                        }
                        catch (IOException e) {
                            this.logger.error((Object)("Could not decode json type: " + new String(header.value()) + " for key: " + header.key()), (Throwable)e);
                            headers.put(header.key(), header.value());
                        }
                    } else {
                        headers.put(header.key(), new NonTrustedHeaderType(header.value(), requestedType));
                    }
                } else {
                    headers.put(header.key(), this.headertValueToAddIn((Header)header));
                }
            }
        });
    }

    private Object decodeValue(Header h, Class<?> type) throws IOException, JsonParseException, JsonMappingException, LinkageError {
        NonTrustedHeaderType nth;
        ObjectMapper headerObjectMapper = this.getObjectMapper();
        Object value = headerObjectMapper.readValue(h.value(), type);
        if (type.equals(NonTrustedHeaderType.class) && this.trusted((nth = (NonTrustedHeaderType)value).getUntrustedType())) {
            try {
                value = headerObjectMapper.readValue(nth.getHeaderValue(), ClassUtils.forName((String)nth.getUntrustedType(), null));
            }
            catch (Exception e) {
                this.logger.error((Object)("Could not decode header: " + nth), (Throwable)e);
            }
        }
        return value;
    }

    @Nullable
    private Map<String, String> decodeJsonTypes(Headers source) {
        Map types = null;
        Iterator iterator = source.iterator();
        ObjectMapper headerObjectMapper = this.getObjectMapper();
        while (iterator.hasNext()) {
            Header next = (Header)iterator.next();
            if (!next.key().equals(JSON_TYPES)) continue;
            try {
                types = (Map)headerObjectMapper.readValue(next.value(), Map.class);
            }
            catch (IOException e) {
                this.logger.error((Object)("Could not decode json types: " + new String(next.value())), (Throwable)e);
            }
            break;
        }
        return types;
    }

    protected boolean trusted(String requestedType) {
        if (requestedType.equals(NonTrustedHeaderType.class.getName())) {
            return true;
        }
        if (!this.trustedPackages.isEmpty()) {
            int lastDot = requestedType.lastIndexOf(46);
            if (lastDot < 0) {
                return false;
            }
            String packageName = requestedType.substring(0, lastDot);
            for (String trustedPackage : this.trustedPackages) {
                if (!packageName.equals(trustedPackage) && !packageName.startsWith(trustedPackage + ".")) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static class NonTrustedHeaderType {
        private byte[] headerValue;
        private String untrustedType;

        public NonTrustedHeaderType() {
        }

        NonTrustedHeaderType(byte[] headerValue, String untrustedType) {
            this.headerValue = headerValue;
            this.untrustedType = untrustedType;
        }

        public void setHeaderValue(byte[] headerValue) {
            this.headerValue = headerValue;
        }

        public byte[] getHeaderValue() {
            return this.headerValue;
        }

        public void setUntrustedType(String untrustedType) {
            this.untrustedType = untrustedType;
        }

        public String getUntrustedType() {
            return this.untrustedType;
        }

        public String toString() {
            try {
                return "NonTrustedHeaderType [headerValue=" + new String(this.headerValue, StandardCharsets.UTF_8) + ", untrustedType=" + this.untrustedType + "]";
            }
            catch (Exception e) {
                return "NonTrustedHeaderType [headerValue=" + Arrays.toString(this.headerValue) + ", untrustedType=" + this.untrustedType + "]";
            }
        }
    }

    private class MimeTypeJsonDeserializer
    extends StdNodeBasedDeserializer<MimeType> {
        private static final long serialVersionUID = 1L;

        MimeTypeJsonDeserializer() {
            super(MimeType.class);
        }

        public MimeType convert(JsonNode root, DeserializationContext ctxt) throws IOException {
            JsonNode type = root.get("type");
            JsonNode subType = root.get("subtype");
            JsonNode parameters = root.get("parameters");
            Map params = (Map)DefaultKafkaHeaderMapper.this.objectMapper.readValue(parameters.traverse(), (JavaType)TypeFactory.defaultInstance().constructMapType(HashMap.class, String.class, String.class));
            return new MimeType(type.asText(), subType.asText(), params);
        }
    }
}

