/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.kafka.config.AbstractKafkaListenerEndpoint;
import org.springframework.kafka.config.KafkaListenerContainerFactory;
import org.springframework.kafka.config.KafkaListenerEndpoint;
import org.springframework.kafka.config.KafkaListenerEndpointAdapter;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.listener.AbstractMessageListenerContainer;
import org.springframework.kafka.listener.AfterRollbackProcessor;
import org.springframework.kafka.listener.BatchErrorHandler;
import org.springframework.kafka.listener.ContainerProperties;
import org.springframework.kafka.listener.ErrorHandler;
import org.springframework.kafka.listener.GenericErrorHandler;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.kafka.listener.RecordInterceptor;
import org.springframework.kafka.listener.adapter.RecordFilterStrategy;
import org.springframework.kafka.listener.adapter.ReplyHeadersConfigurer;
import org.springframework.kafka.requestreply.ReplyingKafkaOperations;
import org.springframework.kafka.support.TopicPartitionInitialOffset;
import org.springframework.kafka.support.converter.MessageConverter;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;

public abstract class AbstractKafkaListenerContainerFactory<C extends AbstractMessageListenerContainer<K, V>, K, V>
implements KafkaListenerContainerFactory<C>,
ApplicationEventPublisherAware,
InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final ContainerProperties containerProperties = new ContainerProperties((Pattern)null);
    private GenericErrorHandler<?> errorHandler;
    private ConsumerFactory<? super K, ? super V> consumerFactory;
    private Boolean autoStartup;
    private Integer phase;
    private MessageConverter messageConverter;
    private RecordFilterStrategy<? super K, ? super V> recordFilterStrategy;
    private Boolean ackDiscarded;
    private RetryTemplate retryTemplate;
    private RecoveryCallback<? extends Object> recoveryCallback;
    private Boolean statefulRetry;
    private Boolean batchListener;
    private ApplicationEventPublisher applicationEventPublisher;
    private KafkaTemplate<?, ?> replyTemplate;
    private AfterRollbackProcessor<? super K, ? super V> afterRollbackProcessor;
    private ReplyHeadersConfigurer replyHeadersConfigurer;
    private RecordInterceptor<K, V> recordInterceptor;

    public void setConsumerFactory(ConsumerFactory<? super K, ? super V> consumerFactory) {
        this.consumerFactory = consumerFactory;
    }

    public ConsumerFactory<? super K, ? super V> getConsumerFactory() {
        return this.consumerFactory;
    }

    public void setAutoStartup(Boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public void setRecordFilterStrategy(RecordFilterStrategy<? super K, ? super V> recordFilterStrategy) {
        this.recordFilterStrategy = recordFilterStrategy;
    }

    public void setAckDiscarded(Boolean ackDiscarded) {
        this.ackDiscarded = ackDiscarded;
    }

    public void setRetryTemplate(RetryTemplate retryTemplate) {
        this.retryTemplate = retryTemplate;
    }

    public void setRecoveryCallback(RecoveryCallback<? extends Object> recoveryCallback) {
        this.recoveryCallback = recoveryCallback;
    }

    public void setStatefulRetry(boolean statefulRetry) {
        this.statefulRetry = statefulRetry;
    }

    public Boolean isBatchListener() {
        return this.batchListener;
    }

    public void setBatchListener(Boolean batchListener) {
        this.batchListener = batchListener;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void setReplyTemplate(KafkaTemplate<?, ?> replyTemplate) {
        if (replyTemplate instanceof ReplyingKafkaOperations) {
            this.logger.warn((Object)"The 'replyTemplate' should not be an implementation of 'ReplyingKafkaOperations'; such implementations are for client-side request/reply operations; here we are simply sending a reply to an incoming request so the reply container will never be used and will consume unnecessary resources.");
        }
        this.replyTemplate = replyTemplate;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setBatchErrorHandler(BatchErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setAfterRollbackProcessor(AfterRollbackProcessor<? super K, ? super V> afterRollbackProcessor) {
        this.afterRollbackProcessor = afterRollbackProcessor;
    }

    public void setReplyHeadersConfigurer(ReplyHeadersConfigurer replyHeadersConfigurer) {
        this.replyHeadersConfigurer = replyHeadersConfigurer;
    }

    public ContainerProperties getContainerProperties() {
        return this.containerProperties;
    }

    public void setRecordInterceptor(RecordInterceptor<K, V> recordInterceptor) {
        this.recordInterceptor = recordInterceptor;
    }

    public void afterPropertiesSet() {
        if (this.errorHandler != null) {
            if (Boolean.TRUE.equals(this.batchListener)) {
                Assert.state((boolean)(this.errorHandler instanceof BatchErrorHandler), () -> "The error handler must be a BatchErrorHandler, not " + this.errorHandler.getClass().getName());
            } else {
                Assert.state((boolean)(this.errorHandler instanceof ErrorHandler), () -> "The error handler must be an ErrorHandler, not " + this.errorHandler.getClass().getName());
            }
        }
    }

    @Override
    public C createListenerContainer(KafkaListenerEndpoint endpoint) {
        C instance = this.createContainerInstance(endpoint);
        if (endpoint.getId() != null) {
            ((AbstractMessageListenerContainer)instance).setBeanName(endpoint.getId());
        }
        if (endpoint instanceof AbstractKafkaListenerEndpoint) {
            this.configureEndpoint((AbstractKafkaListenerEndpoint)endpoint);
        }
        endpoint.setupListenerContainer((MessageListenerContainer)instance, this.messageConverter);
        this.initializeContainer(instance, endpoint);
        return instance;
    }

    private void configureEndpoint(AbstractKafkaListenerEndpoint<K, V> aklEndpoint) {
        if (this.recordFilterStrategy != null) {
            aklEndpoint.setRecordFilterStrategy(this.recordFilterStrategy);
        }
        if (this.ackDiscarded != null) {
            aklEndpoint.setAckDiscarded(this.ackDiscarded);
        }
        if (this.retryTemplate != null) {
            aklEndpoint.setRetryTemplate(this.retryTemplate);
        }
        if (this.recoveryCallback != null) {
            aklEndpoint.setRecoveryCallback(this.recoveryCallback);
        }
        if (this.statefulRetry != null) {
            aklEndpoint.setStatefulRetry(this.statefulRetry);
        }
        if (this.batchListener != null) {
            aklEndpoint.setBatchListener(this.batchListener);
        }
        if (this.replyTemplate != null) {
            aklEndpoint.setReplyTemplate(this.replyTemplate);
        }
        if (this.replyHeadersConfigurer != null) {
            aklEndpoint.setReplyHeadersConfigurer(this.replyHeadersConfigurer);
        }
    }

    protected abstract C createContainerInstance(KafkaListenerEndpoint var1);

    protected void initializeContainer(C instance, KafkaListenerEndpoint endpoint) {
        ContainerProperties properties = ((AbstractMessageListenerContainer)instance).getContainerProperties();
        BeanUtils.copyProperties((Object)this.containerProperties, (Object)properties, (String[])new String[]{"topics", "topicPartitions", "topicPattern", "messageListener", "ackCount", "ackTime"});
        if (this.afterRollbackProcessor != null) {
            ((AbstractMessageListenerContainer)instance).setAfterRollbackProcessor(this.afterRollbackProcessor);
        }
        if (this.containerProperties.getAckCount() > 0) {
            properties.setAckCount(this.containerProperties.getAckCount());
        }
        if (this.containerProperties.getAckTime() > 0L) {
            properties.setAckTime(this.containerProperties.getAckTime());
        }
        if (this.errorHandler != null) {
            ((AbstractMessageListenerContainer)instance).setGenericErrorHandler(this.errorHandler);
        }
        if (endpoint.getAutoStartup() != null) {
            ((AbstractMessageListenerContainer)instance).setAutoStartup(endpoint.getAutoStartup());
        } else if (this.autoStartup != null) {
            ((AbstractMessageListenerContainer)instance).setAutoStartup(this.autoStartup);
        }
        ((AbstractMessageListenerContainer)instance).setRecordInterceptor(this.recordInterceptor);
        if (this.phase != null) {
            ((AbstractMessageListenerContainer)instance).setPhase(this.phase);
        }
        if (this.applicationEventPublisher != null) {
            ((AbstractMessageListenerContainer)instance).setApplicationEventPublisher(this.applicationEventPublisher);
        }
        ((AbstractMessageListenerContainer)instance).getContainerProperties().setGroupId(endpoint.getGroupId());
        ((AbstractMessageListenerContainer)instance).getContainerProperties().setClientId(endpoint.getClientIdPrefix());
        if (endpoint.getConsumerProperties() != null) {
            ((AbstractMessageListenerContainer)instance).getContainerProperties().setConsumerProperties(endpoint.getConsumerProperties());
        }
    }

    @Override
    public C createContainer(final Collection<TopicPartitionInitialOffset> topicPartitions) {
        KafkaListenerEndpointAdapter endpoint = new KafkaListenerEndpointAdapter(){

            @Override
            public Collection<TopicPartitionInitialOffset> getTopicPartitions() {
                return topicPartitions;
            }
        };
        C container = this.createContainerInstance(endpoint);
        this.initializeContainer(container, endpoint);
        return container;
    }

    @Override
    public C createContainer(final String ... topics) {
        KafkaListenerEndpointAdapter endpoint = new KafkaListenerEndpointAdapter(){

            @Override
            public Collection<String> getTopics() {
                return Arrays.asList(topics);
            }
        };
        C container = this.createContainerInstance(endpoint);
        this.initializeContainer(container, endpoint);
        return container;
    }

    @Override
    public C createContainer(final Pattern topicPattern) {
        KafkaListenerEndpointAdapter endpoint = new KafkaListenerEndpointAdapter(){

            @Override
            public Pattern getTopicPattern() {
                return topicPattern;
            }
        };
        C container = this.createContainerInstance(endpoint);
        this.initializeContainer(container, endpoint);
        return container;
    }
}

