/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support;

import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.springframework.util.Assert;

public final class LogIfLevelEnabled {
    private final Log logger;
    private final Level level;

    public LogIfLevelEnabled(Log logger, Level level) {
        Assert.notNull((Object)logger, (String)"'logger' cannot be null");
        Assert.notNull((Object)((Object)level), (String)"'level' cannot be null");
        this.logger = logger;
        this.level = level;
    }

    public void log(Supplier<Object> messageSupplier) {
        switch (this.level) {
            case FATAL: {
                this.fatal(messageSupplier, null);
                break;
            }
            case ERROR: {
                this.error(messageSupplier, null);
                break;
            }
            case WARN: {
                this.warn(messageSupplier, null);
                break;
            }
            case INFO: {
                this.info(messageSupplier, null);
                break;
            }
            case DEBUG: {
                this.debug(messageSupplier, null);
                break;
            }
            case TRACE: {
                this.trace(messageSupplier, null);
            }
        }
    }

    public void log(Supplier<Object> messageSupplier, Throwable t) {
        switch (this.level) {
            case FATAL: {
                this.fatal(messageSupplier, t);
                break;
            }
            case ERROR: {
                this.error(messageSupplier, t);
                break;
            }
            case WARN: {
                this.warn(messageSupplier, t);
                break;
            }
            case INFO: {
                this.info(messageSupplier, t);
                break;
            }
            case DEBUG: {
                this.debug(messageSupplier, t);
                break;
            }
            case TRACE: {
                this.trace(messageSupplier, t);
            }
        }
    }

    private void fatal(Supplier<Object> messageSupplier, Throwable t) {
        if (this.logger.isFatalEnabled()) {
            if (t != null) {
                this.logger.fatal(messageSupplier.get(), t);
            } else {
                this.logger.fatal(messageSupplier.get());
            }
        }
    }

    private void error(Supplier<Object> messageSupplier, Throwable t) {
        if (this.logger.isErrorEnabled()) {
            if (t != null) {
                this.logger.error(messageSupplier.get(), t);
            } else {
                this.logger.error(messageSupplier.get());
            }
        }
    }

    private void warn(Supplier<Object> messageSupplier, Throwable t) {
        if (this.logger.isWarnEnabled()) {
            if (t != null) {
                this.logger.warn(messageSupplier.get(), t);
            } else {
                this.logger.warn(messageSupplier.get());
            }
        }
    }

    private void info(Supplier<Object> messageSupplier, Throwable t) {
        if (this.logger.isInfoEnabled()) {
            if (t != null) {
                this.logger.info(messageSupplier.get(), t);
            } else {
                this.logger.info(messageSupplier.get());
            }
        }
    }

    private void debug(Supplier<Object> messageSupplier, Throwable t) {
        if (this.logger.isDebugEnabled()) {
            if (t != null) {
                this.logger.debug(messageSupplier.get(), t);
            } else {
                this.logger.debug(messageSupplier.get());
            }
        }
    }

    private void trace(Supplier<Object> messageSupplier, Throwable t) {
        if (this.logger.isTraceEnabled()) {
            if (t != null) {
                this.logger.trace(messageSupplier.get(), t);
            } else {
                this.logger.trace(messageSupplier.get());
            }
        }
    }

    public static enum Level {
        FATAL,
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE;

    }
}

