/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.config;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.streams.KafkaClientSupplier;
import org.apache.kafka.streams.KafkaStreams;
import org.apache.kafka.streams.StreamsBuilder;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.Topology;
import org.apache.kafka.streams.processor.StateRestoreListener;
import org.apache.kafka.streams.processor.internals.DefaultKafkaClientSupplier;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.context.SmartLifecycle;
import org.springframework.kafka.KafkaException;
import org.springframework.kafka.config.KafkaStreamsConfiguration;
import org.springframework.kafka.config.KafkaStreamsCustomizer;
import org.springframework.kafka.core.CleanupConfig;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class StreamsBuilderFactoryBean
extends AbstractFactoryBean<StreamsBuilder>
implements SmartLifecycle {
    private static final Log logger = LogFactory.getLog(StreamsBuilderFactoryBean.class);
    private static final String STREAMS_CONFIG_MUST_NOT_BE_NULL = "'streamsConfig' must not be null";
    private static final String CLEANUP_CONFIG_MUST_NOT_BE_NULL = "'cleanupConfig' must not be null";
    private static final int DEFAULT_CLOSE_TIMEOUT = 10;
    private KafkaClientSupplier clientSupplier = new DefaultKafkaClientSupplier();
    private StreamsConfig streamsConfig;
    private Properties properties;
    private final CleanupConfig cleanupConfig;
    private KafkaStreamsCustomizer kafkaStreamsCustomizer;
    private KafkaStreams.StateListener stateListener;
    private StateRestoreListener stateRestoreListener;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private boolean autoStartup = true;
    private int phase = 2147482647;
    private int closeTimeout = 10;
    private KafkaStreams kafkaStreams;
    private volatile boolean running;

    public StreamsBuilderFactoryBean() {
        this.cleanupConfig = new CleanupConfig();
    }

    @Deprecated
    public StreamsBuilderFactoryBean(StreamsConfig streamsConfig) {
        this(streamsConfig, new CleanupConfig());
    }

    @Deprecated
    public StreamsBuilderFactoryBean(StreamsConfig streamsConfig, CleanupConfig cleanupConfig) {
        Assert.notNull((Object)streamsConfig, (String)STREAMS_CONFIG_MUST_NOT_BE_NULL);
        Assert.notNull((Object)cleanupConfig, (String)CLEANUP_CONFIG_MUST_NOT_BE_NULL);
        this.streamsConfig = streamsConfig;
        this.cleanupConfig = cleanupConfig;
    }

    public StreamsBuilderFactoryBean(KafkaStreamsConfiguration streamsConfig, CleanupConfig cleanupConfig) {
        Assert.notNull((Object)streamsConfig, (String)STREAMS_CONFIG_MUST_NOT_BE_NULL);
        Assert.notNull((Object)cleanupConfig, (String)CLEANUP_CONFIG_MUST_NOT_BE_NULL);
        this.properties = streamsConfig.asProperties();
        this.cleanupConfig = cleanupConfig;
    }

    @Deprecated
    public StreamsBuilderFactoryBean(Map<String, Object> streamsConfig) {
        this(streamsConfig, new CleanupConfig());
    }

    public StreamsBuilderFactoryBean(KafkaStreamsConfiguration streamsConfig) {
        this(streamsConfig, new CleanupConfig());
    }

    @Deprecated
    public StreamsBuilderFactoryBean(Map<String, Object> streamsConfig, CleanupConfig cleanupConfig) {
        Assert.notNull(streamsConfig, (String)STREAMS_CONFIG_MUST_NOT_BE_NULL);
        Assert.notNull((Object)cleanupConfig, (String)CLEANUP_CONFIG_MUST_NOT_BE_NULL);
        this.streamsConfig = new StreamsConfig(streamsConfig);
        this.cleanupConfig = cleanupConfig;
    }

    public void setStreamsConfig(StreamsConfig streamsConfig) {
        Assert.notNull((Object)streamsConfig, (String)STREAMS_CONFIG_MUST_NOT_BE_NULL);
        Assert.isNull((Object)this.properties, (String)"Cannot have both streamsConfig and streams configuration properties");
        this.streamsConfig = streamsConfig;
    }

    @Nullable
    public StreamsConfig getStreamsConfig() {
        return this.streamsConfig;
    }

    public void setStreamsConfiguration(Properties streamsConfig) {
        Assert.notNull((Object)streamsConfig, (String)STREAMS_CONFIG_MUST_NOT_BE_NULL);
        Assert.isNull((Object)this.streamsConfig, (String)"Cannot have both streamsConfig and streams configuration properties");
        this.properties = streamsConfig;
    }

    @Nullable
    public Properties getStreamsConfiguration() {
        return this.properties;
    }

    public void setClientSupplier(KafkaClientSupplier clientSupplier) {
        Assert.notNull((Object)clientSupplier, (String)"'clientSupplier' must not be null");
        this.clientSupplier = clientSupplier;
    }

    public void setKafkaStreamsCustomizer(KafkaStreamsCustomizer kafkaStreamsCustomizer) {
        Assert.notNull((Object)kafkaStreamsCustomizer, (String)"'kafkaStreamsCustomizer' must not be null");
        this.kafkaStreamsCustomizer = kafkaStreamsCustomizer;
    }

    public void setStateListener(KafkaStreams.StateListener stateListener) {
        this.stateListener = stateListener;
    }

    public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler exceptionHandler) {
        this.uncaughtExceptionHandler = exceptionHandler;
    }

    public void setStateRestoreListener(StateRestoreListener stateRestoreListener) {
        this.stateRestoreListener = stateRestoreListener;
    }

    public void setCloseTimeout(int closeTimeout) {
        this.closeTimeout = closeTimeout;
    }

    public Class<?> getObjectType() {
        return StreamsBuilder.class;
    }

    protected StreamsBuilder createInstance() {
        if (this.autoStartup) {
            Assert.state((this.streamsConfig != null || this.properties != null ? 1 : 0) != 0, (String)"'streamsConfig' or streams configuration properties must not be null");
        }
        return new StreamsBuilder();
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void stop(Runnable callback) {
        this.stop();
        if (callback != null) {
            callback.run();
        }
    }

    public synchronized void start() {
        if (!this.running) {
            try {
                Assert.state((this.streamsConfig != null || this.properties != null ? 1 : 0) != 0, (String)"'streamsConfig' or streams configuration properties must not be null");
                Topology topology = ((StreamsBuilder)this.getObject()).build();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)topology.describe());
                }
                this.kafkaStreams = this.properties != null ? new KafkaStreams(topology, this.properties, this.clientSupplier) : new KafkaStreams(topology, this.streamsConfig, this.clientSupplier);
                this.kafkaStreams.setStateListener(this.stateListener);
                this.kafkaStreams.setGlobalStateRestoreListener(this.stateRestoreListener);
                this.kafkaStreams.setUncaughtExceptionHandler(this.uncaughtExceptionHandler);
                if (this.kafkaStreamsCustomizer != null) {
                    this.kafkaStreamsCustomizer.customize(this.kafkaStreams);
                }
                if (this.cleanupConfig.cleanupOnStart()) {
                    this.kafkaStreams.cleanUp();
                }
                this.kafkaStreams.start();
                this.running = true;
            }
            catch (Exception e) {
                throw new KafkaException("Could not start stream: ", e);
            }
        }
    }

    public synchronized void stop() {
        if (this.running) {
            try {
                if (this.kafkaStreams != null) {
                    this.kafkaStreams.close((long)this.closeTimeout, TimeUnit.SECONDS);
                    if (this.cleanupConfig.cleanupOnStop()) {
                        this.kafkaStreams.cleanUp();
                    }
                    this.kafkaStreams = null;
                }
            }
            catch (Exception e) {
                logger.error((Object)"Failed to stop streams", (Throwable)e);
            }
            finally {
                this.running = false;
            }
        }
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return this.phase;
    }

    public KafkaStreams getKafkaStreams() {
        return this.kafkaStreams;
    }
}

