/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.Deserializer;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class DefaultKafkaConsumerFactory<K, V>
implements ConsumerFactory<K, V> {
    private final Map<String, Object> configs;
    private Deserializer<K> keyDeserializer;
    private Deserializer<V> valueDeserializer;

    public DefaultKafkaConsumerFactory(Map<String, Object> configs) {
        this(configs, null, null);
    }

    public DefaultKafkaConsumerFactory(Map<String, Object> configs, @Nullable Deserializer<K> keyDeserializer, @Nullable Deserializer<V> valueDeserializer) {
        this.configs = new HashMap<String, Object>(configs);
        this.keyDeserializer = keyDeserializer;
        this.valueDeserializer = valueDeserializer;
    }

    public void setKeyDeserializer(@Nullable Deserializer<K> keyDeserializer) {
        this.keyDeserializer = keyDeserializer;
    }

    public void setValueDeserializer(@Nullable Deserializer<V> valueDeserializer) {
        this.valueDeserializer = valueDeserializer;
    }

    @Override
    public Map<String, Object> getConfigurationProperties() {
        return Collections.unmodifiableMap(this.configs);
    }

    @Override
    public Deserializer<K> getKeyDeserializer() {
        return this.keyDeserializer;
    }

    @Override
    public Deserializer<V> getValueDeserializer() {
        return this.valueDeserializer;
    }

    @Override
    public Consumer<K, V> createConsumer(@Nullable String groupId, @Nullable String clientIdPrefix, @Nullable String clientIdSuffix) {
        return this.createKafkaConsumer(groupId, clientIdPrefix, clientIdSuffix);
    }

    protected KafkaConsumer<K, V> createKafkaConsumer(@Nullable String groupId, @Nullable String clientIdPrefix, @Nullable String clientIdSuffixArg) {
        boolean shouldModifyClientId;
        boolean overrideClientIdPrefix = StringUtils.hasText((String)clientIdPrefix);
        String clientIdSuffix = clientIdSuffixArg;
        if (clientIdSuffix == null) {
            clientIdSuffix = "";
        }
        boolean bl = shouldModifyClientId = this.configs.containsKey("client.id") && StringUtils.hasText((String)clientIdSuffix) || overrideClientIdPrefix;
        if (groupId == null && !shouldModifyClientId) {
            return this.createKafkaConsumer(this.configs);
        }
        HashMap<String, Object> modifiedConfigs = new HashMap<String, Object>(this.configs);
        if (groupId != null) {
            modifiedConfigs.put("group.id", groupId);
        }
        if (shouldModifyClientId) {
            modifiedConfigs.put("client.id", (overrideClientIdPrefix ? clientIdPrefix : modifiedConfigs.get("client.id")) + clientIdSuffix);
        }
        return this.createKafkaConsumer(modifiedConfigs);
    }

    protected KafkaConsumer<K, V> createKafkaConsumer(Map<String, Object> configs) {
        return new KafkaConsumer(configs, this.keyDeserializer, this.valueDeserializer);
    }

    @Override
    public boolean isAutoCommit() {
        Object auto = this.configs.get("enable.auto.commit");
        return auto instanceof Boolean ? (Boolean)auto : (auto instanceof String ? Boolean.valueOf((String)auto) : true);
    }
}

