/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiPredicate;
import org.apache.commons.logging.Log;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;

public final class SeekUtils {
    public static final int DEFAULT_MAX_FAILURES = 10;

    private SeekUtils() {
    }

    public static boolean doSeeks(List<ConsumerRecord<?, ?>> records, Consumer<?, ?> consumer, Exception exception, boolean recoverable, BiPredicate<ConsumerRecord<?, ?>, Exception> skipper, Log logger) {
        LinkedHashMap<TopicPartition, Long> partitions = new LinkedHashMap<TopicPartition, Long>();
        AtomicBoolean first = new AtomicBoolean(true);
        AtomicBoolean skipped = new AtomicBoolean();
        records.forEach(record -> {
            if (recoverable && first.get()) {
                try {
                    boolean test = skipper.test((ConsumerRecord<?, ?>)record, exception);
                    skipped.set(test);
                }
                catch (Exception ex) {
                    logger.error((Object)"Failed to determine if this record should be recovererd, including in seeks", (Throwable)ex);
                    skipped.set(false);
                }
                if (skipped.get() && logger.isDebugEnabled()) {
                    logger.debug((Object)("Skipping seek of: " + record));
                }
            }
            if (!(recoverable && first.get() && skipped.get())) {
                partitions.computeIfAbsent(new TopicPartition(record.topic(), record.partition()), offset -> record.offset());
            }
            first.set(false);
        });
        boolean tracing = logger.isTraceEnabled();
        partitions.forEach((topicPartition, offset) -> {
            try {
                if (tracing) {
                    logger.trace((Object)("Seeking: " + topicPartition + " to: " + offset));
                }
                consumer.seek(topicPartition, offset.longValue());
            }
            catch (Exception e) {
                logger.error((Object)("Failed to seek " + topicPartition + " to " + offset), (Throwable)e);
            }
        });
        return skipped.get();
    }
}

