/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.listener.AfterRollbackProcessor;
import org.springframework.kafka.listener.FailedRecordTracker;
import org.springframework.kafka.support.SeekUtils;
import org.springframework.lang.Nullable;

public class DefaultAfterRollbackProcessor<K, V>
implements AfterRollbackProcessor<K, V> {
    private static final Log logger = LogFactory.getLog(DefaultAfterRollbackProcessor.class);
    private final FailedRecordTracker failureTracker;
    private boolean processInTransaction;
    private KafkaTemplate<K, V> kafkaTemplate;

    public DefaultAfterRollbackProcessor() {
        this(null, 10);
    }

    public DefaultAfterRollbackProcessor(int maxFailures) {
        this(null, maxFailures);
    }

    public DefaultAfterRollbackProcessor(BiConsumer<ConsumerRecord<?, ?>, Exception> recoverer) {
        this(recoverer, 10);
    }

    public DefaultAfterRollbackProcessor(@Nullable BiConsumer<ConsumerRecord<?, ?>, Exception> recoverer, int maxFailures) {
        this.failureTracker = new FailedRecordTracker(recoverer, maxFailures, logger);
    }

    @Override
    public void process(List<ConsumerRecord<K, V>> records, Consumer<K, V> consumer, Exception exception, boolean recoverable) {
        if (SeekUtils.doSeeks(records, consumer, exception, recoverable, this.failureTracker::skip, logger) && this.kafkaTemplate != null && this.kafkaTemplate.isTransactional()) {
            ConsumerRecord<?, ?> skipped = records.get(0);
            this.kafkaTemplate.sendOffsetsToTransaction(Collections.singletonMap(new TopicPartition(skipped.topic(), skipped.partition()), new OffsetAndMetadata(skipped.offset() + 1L)));
        }
    }

    @Override
    public boolean isProcessInTransaction() {
        return this.processInTransaction;
    }

    public void setProcessInTransaction(boolean processInTransaction) {
        this.processInTransaction = processInTransaction;
    }

    public void setKafkaTemplate(KafkaTemplate<K, V> kafkaTemplate) {
        this.kafkaTemplate = kafkaTemplate;
    }

    @Override
    public void clearThreadState() {
        this.failureTracker.clearThreadState();
    }
}

