/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.annotation;

import org.apache.kafka.streams.StreamsConfig;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.UnsatisfiedDependencyException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.core.StreamsBuilderFactoryBean;

@Configuration
public class KafkaStreamsDefaultConfiguration {
    public static final String DEFAULT_STREAMS_CONFIG_BEAN_NAME = "defaultKafkaStreamsConfig";
    public static final String DEFAULT_STREAMS_BUILDER_BEAN_NAME = "defaultKafkaStreamsBuilder";

    @Bean(name={"defaultKafkaStreamsBuilder"})
    public StreamsBuilderFactoryBean defaultKafkaStreamsBuilder(@Qualifier(value="defaultKafkaStreamsConfig") ObjectProvider<StreamsConfig> streamsConfigProvider) {
        StreamsConfig streamsConfig = (StreamsConfig)streamsConfigProvider.getIfAvailable();
        if (streamsConfig != null) {
            return new StreamsBuilderFactoryBean(streamsConfig);
        }
        throw new UnsatisfiedDependencyException(KafkaStreamsDefaultConfiguration.class.getName(), DEFAULT_STREAMS_BUILDER_BEAN_NAME, "streamsConfig", "There is no 'defaultKafkaStreamsConfig' StreamsConfig bean in the application context.\nConsider to declare one or don't use @EnableKafkaStreams.");
    }
}

