/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.process;

import java.lang.reflect.Method;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Advisor;
import org.springframework.aop.PointcutAdvisor;
import org.springframework.aop.aspectj.annotation.AspectJAdvisorFactory;
import org.springframework.aop.aspectj.annotation.BeanFactoryAspectInstanceFactory;
import org.springframework.aop.aspectj.annotation.MetadataAwareAspectInstanceFactory;
import org.springframework.aop.aspectj.annotation.NotAnAtAspectException;
import org.springframework.aop.aspectj.annotation.ReflectiveAspectJAdvisorFactory;
import org.springframework.config.java.annotation.Configuration;
import org.springframework.config.java.process.AbstractAopConfigurationListener;
import org.springframework.config.java.process.ConfigurationProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AspectJAdviceConfigurationListener
extends AbstractAopConfigurationListener {
    private AspectJAdvisorFactory aspectJAdvisorFactory = new ReflectiveAspectJAdvisorFactory();

    AspectJAdviceConfigurationListener() {
    }

    @Override
    public boolean understands(Class<?> configurerClass) {
        return this.aspectJAdvisorFactory.isAspect(configurerClass) && configurerClass.isAnnotationPresent(Configuration.class);
    }

    @Override
    public void configurationClass(ConfigurationProcessor cp, String configurerBeanName, Class<?> configurerClass) {
        if (this.aspectJAdvisorFactory.isAspect(configurerClass)) {
            this.aspectJAdvisorFactory.validate(configurerClass);
        }
    }

    @Override
    public void otherMethod(ConfigurationProcessor cp, String configurerBeanName, Class<?> configurerClass, Method aspectJAdviceMethod) {
        try {
            this.aspectJAdvisorFactory.validate(configurerClass);
        }
        catch (NotAnAtAspectException ex) {
            return;
        }
        int declarationOrderInAspect = 0;
        String aspectName = "aspectName";
        Advisor pa = this.aspectJAdvisorFactory.getAdvisor(aspectJAdviceMethod, (MetadataAwareAspectInstanceFactory)new BeanFactoryAspectInstanceFactory(cp.getChildBeanFactory(), this.getConfigurerBeanName(configurerClass), configurerClass), declarationOrderInAspect, aspectName);
        if (pa != null && pa instanceof PointcutAdvisor) {
            String adviceName = aspectJAdviceMethod.getName();
            Advice advice = pa.getAdvice();
            if (advice == null) {
                return;
            }
            this.addAdvice(adviceName, ((PointcutAdvisor)pa).getPointcut(), advice, cp);
            ++cp.beanDefsGenerated;
        }
    }

    protected String getConfigurerBeanName(Class<?> configClass) {
        return configClass.getName();
    }
}

