/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.zookeeper.lock;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.springframework.integration.support.locks.ExpirableLockRegistry;
import org.springframework.messaging.MessagingException;
import org.springframework.util.Assert;

public class ZookeeperLockRegistry
implements ExpirableLockRegistry {
    private static final String DEFAULT_ROOT = "/SpringIntegration-LockRegistry";
    private final CuratorFramework client;
    private final KeyToPathStrategy keyToPath;
    private final Map<String, ZkLock> locks = new HashMap<String, ZkLock>();
    private final boolean trackingTime;

    public ZookeeperLockRegistry(CuratorFramework client) {
        this(client, DEFAULT_ROOT);
    }

    public ZookeeperLockRegistry(CuratorFramework client, String root) {
        this(client, new DefaultKeyToPathStrategy(root));
    }

    public ZookeeperLockRegistry(CuratorFramework client, KeyToPathStrategy keyToPath) {
        Assert.notNull((Object)client, (String)"'client' cannot be null");
        Assert.notNull((Object)client, (String)"'keyToPath' cannot be null");
        this.client = client;
        this.keyToPath = keyToPath;
        this.trackingTime = !keyToPath.bounded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lock obtain(Object lockKey) {
        Assert.isInstanceOf(String.class, (Object)lockKey);
        String path = this.keyToPath.pathFor((String)lockKey);
        ZkLock lock = this.locks.get(path);
        if (lock == null) {
            Map<String, ZkLock> map = this.locks;
            synchronized (map) {
                lock = this.locks.get(path);
                if (lock == null) {
                    lock = new ZkLock(this.client, path);
                    this.locks.put(path, lock);
                }
                if (this.trackingTime) {
                    lock.setLastUsed(System.currentTimeMillis());
                }
            }
        }
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireUnusedOlderThan(long age) {
        if (!this.trackingTime) {
            throw new IllegalStateException("Ths KeyToPathStrategy is bounded; expiry is not supported");
        }
        Map<String, ZkLock> map = this.locks;
        synchronized (map) {
            Iterator<Map.Entry<String, ZkLock>> iterator = this.locks.entrySet().iterator();
            long now = System.currentTimeMillis();
            while (iterator.hasNext()) {
                Map.Entry<String, ZkLock> entry = iterator.next();
                ZkLock lock = entry.getValue();
                if (now - lock.getLastUsed() <= age || lock.isAcquiredInThisProcess()) continue;
                iterator.remove();
            }
        }
    }

    private static class ZkLock
    implements Lock {
        private final InterProcessMutex mutex;
        private final String path;
        private long lastUsed;

        public ZkLock(CuratorFramework client, String path) {
            this.mutex = new InterProcessMutex(client, path);
            this.path = path;
        }

        public long getLastUsed() {
            return this.lastUsed;
        }

        public void setLastUsed(long lastUsed) {
            this.lastUsed = lastUsed;
        }

        @Override
        public void lock() {
            try {
                this.mutex.acquire();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to aquire mutex at " + this.path, e);
            }
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            boolean locked = false;
            while (!locked) {
                locked = this.tryLock(1L, TimeUnit.SECONDS);
            }
        }

        @Override
        public boolean tryLock() {
            try {
                return this.tryLock(0L, TimeUnit.MICROSECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            try {
                return this.mutex.acquire(time, unit);
            }
            catch (Exception e) {
                throw new MessagingException("Failed to aquire mutex at " + this.path, (Throwable)e);
            }
        }

        @Override
        public void unlock() {
            try {
                this.mutex.release();
            }
            catch (Exception e) {
                throw new MessagingException("Failed to release mutex at " + this.path, (Throwable)e);
            }
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException("Conditions are not supported");
        }

        public boolean isAcquiredInThisProcess() {
            return this.mutex.isAcquiredInThisProcess();
        }
    }

    private static class DefaultKeyToPathStrategy
    implements KeyToPathStrategy {
        private final String root;

        public DefaultKeyToPathStrategy(String rootPath) {
            Assert.notNull((Object)rootPath, (String)"'rootPath' cannot be null");
            this.root = !rootPath.endsWith("/") ? rootPath + "/" : rootPath;
        }

        @Override
        public String pathFor(String key) {
            return this.root + key;
        }

        @Override
        public boolean bounded() {
            return false;
        }
    }

    public static interface KeyToPathStrategy {
        public String pathFor(String var1);

        public boolean bounded();
    }
}

