/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xmpp.outbound;

import java.util.regex.Pattern;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaBuilder;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.springframework.integration.xmpp.core.AbstractXmppConnectionAwareMessageHandler;
import org.springframework.integration.xmpp.support.DefaultXmppHeaderMapper;
import org.springframework.integration.xmpp.support.XmppHeaderMapper;
import org.springframework.messaging.MessageHandlingException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ChatMessageSendingMessageHandler
extends AbstractXmppConnectionAwareMessageHandler {
    private static final Pattern XML_PATTERN = Pattern.compile("<(\\S[^>\\s]*)[^>]*>[^<]*</\\1>");
    private XmppHeaderMapper headerMapper = new DefaultXmppHeaderMapper();
    private ExtensionElementProvider<? extends ExtensionElement> extensionProvider;

    public ChatMessageSendingMessageHandler() {
    }

    public ChatMessageSendingMessageHandler(XMPPConnection xmppConnection) {
        super(xmppConnection);
    }

    public void setHeaderMapper(XmppHeaderMapper headerMapper) {
        Assert.notNull((Object)headerMapper, (String)"headerMapper must not be null");
        this.headerMapper = headerMapper;
    }

    public void setExtensionProvider(ExtensionElementProvider<? extends ExtensionElement> extensionProvider) {
        this.extensionProvider = extensionProvider;
    }

    public String getComponentType() {
        return "xmpp:outbound-channel-adapter";
    }

    protected void handleMessageInternal(org.springframework.messaging.Message<?> message) {
        Assert.isTrue((boolean)this.isInitialized(), () -> this.getComponentName() + "#" + this.getComponentType() + " must be initialized");
        try {
            XMPPConnection xmppConnection;
            MessageBuilder xmppMessageBuilder;
            Message xmppMessage;
            Object payload = message.getPayload();
            if (payload instanceof Message) {
                xmppMessage = (Message)payload;
                xmppMessageBuilder = xmppMessage.asBuilder();
            } else {
                String to = (String)message.getHeaders().get((Object)"xmpp_to", String.class);
                Assert.state((boolean)StringUtils.hasText((String)to), () -> "The 'xmpp_to' header must not be null");
                xmppMessageBuilder = this.buildXmppMessage(payload, to);
            }
            if (this.headerMapper != null) {
                this.headerMapper.fromHeadersToRequest(message.getHeaders(), xmppMessageBuilder);
            }
            if (!(xmppConnection = this.getXmppConnection()).isConnected() && xmppConnection instanceof AbstractXMPPConnection) {
                ((AbstractXMPPConnection)xmppConnection).connect();
            }
            xmppMessage = xmppMessageBuilder.build();
            xmppConnection.sendStanza((Stanza)xmppMessage);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MessageHandlingException(message, "Thread interrupted in the [" + this + "]", (Throwable)e);
        }
        catch (Exception e) {
            throw new MessageHandlingException(message, "Failed to handle message in the [" + this + "]", (Throwable)e);
        }
    }

    private MessageBuilder buildXmppMessage(Object payload, String to) throws Exception {
        Jid toJid = JidCreate.from((String)to);
        MessageBuilder xmppMessageBuilder = (MessageBuilder)StanzaBuilder.buildMessage().to(toJid);
        if (payload instanceof ExtensionElement) {
            ExtensionElement extensionElement = (ExtensionElement)payload;
            xmppMessageBuilder.addExtension(extensionElement);
        } else if (payload instanceof String) {
            if (this.extensionProvider != null) {
                Object data = (String)payload;
                if (!XML_PATTERN.matcher(((String)data).trim()).matches()) {
                    data = "<root>" + (String)data + "</root>";
                }
                XmlPullParser xmlPullParser = PacketParserUtils.getParserFor((String)data);
                ExtensionElement extension = (ExtensionElement)this.extensionProvider.parse(xmlPullParser);
                xmppMessageBuilder.addExtension(extension);
            } else {
                String body = (String)payload;
                xmppMessageBuilder.setBody(body);
            }
        } else {
            throw new IllegalStateException("Only payloads of type java.lang.String, org.jivesoftware.smack.packet.Message or org.jivesoftware.smack.packet.ExtensionElement are supported. Received [" + payload.getClass().getName() + "]. Consider adding a Transformer prior to this adapter.");
        }
        return xmppMessageBuilder;
    }
}

