/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xmpp.inbound;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.roster.Roster;
import org.jivesoftware.smack.roster.RosterListener;
import org.jxmpp.jid.Jid;
import org.springframework.integration.xmpp.core.AbstractXmppConnectionAwareEndpoint;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class PresenceListeningEndpoint
extends AbstractXmppConnectionAwareEndpoint {
    private static final Log logger = LogFactory.getLog(PresenceListeningEndpoint.class);
    private final PresencePublishingRosterListener rosterListener = new PresencePublishingRosterListener();

    public PresenceListeningEndpoint() {
    }

    public PresenceListeningEndpoint(XMPPConnection xmppConnection) {
        super(xmppConnection);
    }

    public String getComponentType() {
        return "xmpp:presence-inbound-channel-adapter";
    }

    protected void doStart() {
        Assert.isTrue((boolean)this.initialized, (String)(this.getComponentName() + " [" + this.getComponentType() + "] must be initialized"));
        Roster roster = Roster.getInstanceFor((XMPPConnection)this.xmppConnection);
        roster.addRosterListener((RosterListener)this.rosterListener);
    }

    protected void doStop() {
        if (this.xmppConnection != null) {
            Roster.getInstanceFor((XMPPConnection)this.xmppConnection).removeRosterListener((RosterListener)this.rosterListener);
        }
    }

    private class PresencePublishingRosterListener
    implements RosterListener {
        PresencePublishingRosterListener() {
        }

        public void entriesAdded(Collection<Jid> entries) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("entries added: " + StringUtils.collectionToCommaDelimitedString(entries)));
            }
        }

        public void entriesUpdated(Collection<Jid> entries) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("entries updated: " + StringUtils.collectionToCommaDelimitedString(entries)));
            }
        }

        public void entriesDeleted(Collection<Jid> entries) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("entries deleted: " + StringUtils.collectionToCommaDelimitedString(entries)));
            }
        }

        public void presenceChanged(Presence presence) {
            if (presence != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("presence changed: " + presence.getFrom() + " - " + presence));
                }
                PresenceListeningEndpoint.this.sendMessage(PresenceListeningEndpoint.this.getMessageBuilderFactory().withPayload((Object)presence).build());
            }
        }
    }
}

