/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xmpp.config;

import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.roster.Roster;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.jivesoftware.smack.tcp.XMPPTCPConnectionConfiguration;
import org.jxmpp.util.XmppStringUtils;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.context.SmartLifecycle;
import org.springframework.util.StringUtils;

public class XmppConnectionFactoryBean
extends AbstractFactoryBean<XMPPConnection>
implements SmartLifecycle {
    private final Object lifecycleMonitor = new Object();
    private XMPPTCPConnectionConfiguration connectionConfiguration;
    private volatile String resource;
    private volatile String user;
    private volatile String password;
    private volatile String serviceName;
    private volatile String host;
    private volatile int port = 5222;
    private volatile Roster.SubscriptionMode subscriptionMode = Roster.getDefaultSubscriptionMode();
    private volatile boolean autoStartup = true;
    private volatile int phase = Integer.MIN_VALUE;
    private volatile boolean running;
    private volatile XMPPTCPConnection connection;

    public void setConnectionConfiguration(XMPPTCPConnectionConfiguration connectionConfiguration) {
        this.connectionConfiguration = connectionConfiguration;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setSubscriptionMode(Roster.SubscriptionMode subscriptionMode) {
        this.subscriptionMode = subscriptionMode;
    }

    public Class<? extends XMPPConnection> getObjectType() {
        return XMPPConnection.class;
    }

    protected XMPPConnection createInstance() throws Exception {
        XMPPTCPConnectionConfiguration connectionConfiguration = this.connectionConfiguration;
        if (this.connectionConfiguration == null) {
            XMPPTCPConnectionConfiguration.Builder builder = (XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)XMPPTCPConnectionConfiguration.builder().setHost(this.host)).setPort(this.port);
            if (StringUtils.hasText((String)this.resource)) {
                builder.setResource((CharSequence)this.resource);
            }
            if (StringUtils.hasText((String)this.serviceName)) {
                ((XMPPTCPConnectionConfiguration.Builder)builder.setUsernameAndPassword((CharSequence)this.user, this.password)).setXmppDomain(this.serviceName);
            } else {
                ((XMPPTCPConnectionConfiguration.Builder)builder.setUsernameAndPassword((CharSequence)XmppStringUtils.parseLocalpart((String)this.user), this.password)).setXmppDomain(this.user);
            }
            connectionConfiguration = builder.build();
        }
        return new XMPPTCPConnection(connectionConfiguration);
    }

    protected XMPPTCPConnection getConnection() {
        try {
            return (XMPPTCPConnection)this.getObject();
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot obtain connection instance", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.running) {
                return;
            }
            XMPPTCPConnection connection = this.getConnection();
            try {
                connection.connect();
                connection.addConnectionListener((ConnectionListener)new LoggingConnectionListener());
                Roster roster = Roster.getInstanceFor((XMPPConnection)connection);
                if (this.subscriptionMode != null) {
                    roster.setSubscriptionMode(this.subscriptionMode);
                } else {
                    roster.setRosterLoadedAtLogin(false);
                }
                connection.login();
                this.running = true;
            }
            catch (Exception e) {
                throw new BeanInitializationException("failed to connect to XMPP service for " + connection.getServiceName(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.isRunning()) {
                this.getConnection().disconnect();
                this.running = false;
            }
        }
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return this.phase;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    private class LoggingConnectionListener
    implements ConnectionListener {
        LoggingConnectionListener() {
        }

        public void reconnectionSuccessful() {
            XmppConnectionFactoryBean.this.logger.debug((Object)"Reconnection successful");
        }

        public void reconnectionFailed(Exception e) {
            XmppConnectionFactoryBean.this.logger.debug((Object)"Reconnection failed", (Throwable)e);
        }

        public void reconnectingIn(int seconds) {
            XmppConnectionFactoryBean.this.logger.debug((Object)("Reconnecting in " + seconds + " seconds"));
        }

        public void connectionClosedOnError(Exception e) {
            XmppConnectionFactoryBean.this.logger.debug((Object)"Connection closed on error", (Throwable)e);
        }

        public void connectionClosed() {
            XmppConnectionFactoryBean.this.logger.debug((Object)"Connection closed");
        }

        public void connected(XMPPConnection connection) {
            XmppConnectionFactoryBean.this.logger.debug((Object)"Connection connected");
        }

        public void authenticated(XMPPConnection connection, boolean resumed) {
            XmppConnectionFactoryBean.this.logger.debug((Object)"Connection authenticated");
        }
    }
}

