/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xml.transformer;

import org.jspecify.annotations.Nullable;
import org.springframework.integration.transformer.AbstractTransformer;
import org.springframework.integration.transformer.MessageTransformationException;
import org.springframework.integration.xml.DefaultXmlPayloadConverter;
import org.springframework.integration.xml.XmlPayloadConverter;
import org.springframework.integration.xml.xpath.XPathEvaluationType;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.xml.xpath.NodeMapper;
import org.springframework.xml.xpath.XPathExpression;
import org.springframework.xml.xpath.XPathExpressionFactory;
import org.w3c.dom.Node;

public class XPathTransformer
extends AbstractTransformer {
    private final XPathExpression xpathExpression;
    private volatile XmlPayloadConverter converter = new DefaultXmlPayloadConverter();
    private volatile XPathEvaluationType evaluationType = XPathEvaluationType.STRING_RESULT;
    private volatile @Nullable NodeMapper<?> nodeMapper;

    public XPathTransformer(String expression) {
        this.xpathExpression = XPathExpressionFactory.createXPathExpression((String)expression);
    }

    public XPathTransformer(XPathExpression expression) {
        Assert.notNull((Object)expression, (String)"expression must not be null");
        this.xpathExpression = expression;
    }

    public void setEvaluationType(XPathEvaluationType evaluationType) {
        Assert.notNull((Object)((Object)evaluationType), (String)"evaluationType must not be null.");
        this.evaluationType = evaluationType;
    }

    public void setNodeMapper(NodeMapper<?> nodeMapper) {
        this.nodeMapper = nodeMapper;
    }

    public void setConverter(XmlPayloadConverter converter) {
        Assert.notNull((Object)converter, (String)"converter must not be null");
        this.converter = converter;
    }

    public String getComponentType() {
        return "xml:xpath-transformer";
    }

    protected Object doTransform(Message<?> message) {
        Node node = this.converter.convertToNode(message.getPayload());
        NodeMapper<?> nodeMapperToUse = this.nodeMapper;
        Object result = nodeMapperToUse != null ? this.xpathExpression.evaluateAsObject(node, nodeMapperToUse) : this.evaluationType.evaluateXPath(this.xpathExpression, node);
        if (result == null) {
            throw new MessageTransformationException(message, "XPath expression evaluated to null");
        }
        return result;
    }
}

