/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xml.transformer;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.jspecify.annotations.Nullable;
import org.springframework.integration.transformer.AbstractPayloadTransformer;
import org.springframework.integration.xml.source.DomSourceFactory;
import org.springframework.integration.xml.source.SourceFactory;
import org.springframework.oxm.Unmarshaller;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.mime.MimeMessage;
import org.springframework.ws.support.MarshallingUtils;
import org.springframework.xml.transform.StringSource;
import org.w3c.dom.Document;

public class UnmarshallingTransformer
extends AbstractPayloadTransformer<Object, Object> {
    private static final boolean MIME_MESSAGE_PRESENT = ClassUtils.isPresent((String)"org.springframework.ws.mime.MimeMessage", null);
    private final Unmarshaller unmarshaller;
    private SourceFactory sourceFactory = new DomSourceFactory();
    private boolean alwaysUseSourceFactory = false;
    private @Nullable MimeMessageUnmarshallerHelper mimeMessageUnmarshallerHelper;

    public UnmarshallingTransformer(Unmarshaller unmarshaller) {
        this.unmarshaller = unmarshaller;
        if (MIME_MESSAGE_PRESENT) {
            this.mimeMessageUnmarshallerHelper = new MimeMessageUnmarshallerHelper(unmarshaller);
        }
    }

    public void setSourceFactory(SourceFactory sourceFactory) {
        Assert.notNull((Object)sourceFactory, (String)"sourceFactory must not be null");
        this.sourceFactory = sourceFactory;
    }

    public void setAlwaysUseSourceFactory(boolean alwaysUseSourceFactory) {
        this.alwaysUseSourceFactory = alwaysUseSourceFactory;
    }

    public String getComponentType() {
        return "xml:unmarshalling-transformer";
    }

    public Object transformPayload(Object payload) {
        Object string;
        InputStream inputStream = null;
        try {
            Source source;
            Object result;
            if (this.mimeMessageUnmarshallerHelper != null && (result = this.mimeMessageUnmarshallerHelper.maybeUnmarshalMimeMessage(payload)) != null) {
                Object object = result;
                return object;
            }
            if (this.alwaysUseSourceFactory) {
                source = this.sourceFactory.createSource(payload);
            } else if (payload instanceof String) {
                string = (String)payload;
                source = new StringSource((String)string);
            } else if (payload instanceof byte[]) {
                byte[] bytes = (byte[])payload;
                source = new StreamSource(new ByteArrayInputStream(bytes));
            } else if (payload instanceof File) {
                File file = (File)payload;
                inputStream = new FileInputStream(file);
                source = new StreamSource(inputStream, file.toURI().toASCIIString());
            } else if (payload instanceof Document) {
                Document document = (Document)payload;
                source = new DOMSource(document);
            } else {
                Source castSource;
                source = payload instanceof Source ? (castSource = (Source)payload) : this.sourceFactory.createSource(payload);
            }
            Assert.state((source != null ? 1 : 0) != 0, () -> "failed to transform message, payload not assignable from " + Source.class.getName() + "and no conversion possible");
            string = this.unmarshaller.unmarshal(source);
        }
        catch (IOException e) {
            throw new UncheckedIOException("failed to unmarshal payload", e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return string;
    }

    private static class MimeMessageUnmarshallerHelper {
        private final Unmarshaller delegate;

        MimeMessageUnmarshallerHelper(Unmarshaller unmarshaller) {
            this.delegate = unmarshaller;
        }

        @Nullable Object maybeUnmarshalMimeMessage(Object payload) throws IOException {
            if (payload instanceof MimeMessage) {
                MimeMessage mimeMessage = (MimeMessage)payload;
                return MarshallingUtils.unmarshal((Unmarshaller)this.delegate, (WebServiceMessage)mimeMessage);
            }
            return null;
        }
    }
}

