/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.xml.selector;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import org.jspecify.annotations.Nullable;
import org.springframework.core.io.Resource;
import org.springframework.core.log.LogAccessor;
import org.springframework.integration.MessageRejectedException;
import org.springframework.integration.core.MessageSelector;
import org.springframework.integration.xml.AggregatedXmlMessageValidationException;
import org.springframework.integration.xml.DefaultXmlPayloadConverter;
import org.springframework.integration.xml.XmlPayloadConverter;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.xml.validation.XmlValidator;
import org.springframework.xml.validation.XmlValidatorFactory;

public class XmlValidatingMessageSelector
implements MessageSelector {
    private static final LogAccessor LOGGER = new LogAccessor(XmlValidatingMessageSelector.class);
    private final XmlValidator xmlValidator;
    private boolean throwExceptionOnRejection;
    private XmlPayloadConverter converter = new DefaultXmlPayloadConverter();

    public XmlValidatingMessageSelector(Resource schema, @Nullable SchemaType schemaType) throws IOException {
        this(XmlValidatorFactory.createValidator((Resource)schema, (String)(schemaType == null ? SchemaType.XML_SCHEMA.getUrl() : schemaType.getUrl())));
    }

    public XmlValidatingMessageSelector(XmlValidator xmlValidator) {
        Assert.notNull((Object)xmlValidator, (String)"XmlValidator must not be null");
        this.xmlValidator = xmlValidator;
    }

    public XmlValidatingMessageSelector(Resource schema, @Nullable String schemaType) throws IOException {
        this(schema, StringUtils.hasText((String)schemaType) ? SchemaType.valueOf(schemaType.toUpperCase().replaceFirst("-", "_")) : null);
    }

    public void setThrowExceptionOnRejection(boolean throwExceptionOnRejection) {
        this.throwExceptionOnRejection = throwExceptionOnRejection;
    }

    public void setConverter(XmlPayloadConverter converter) {
        Assert.notNull((Object)converter, (String)"'converter' must not be null");
        this.converter = converter;
    }

    public boolean accept(Message<?> message) {
        Object[] validationExceptions;
        try {
            validationExceptions = this.xmlValidator.validate(this.converter.convertToSource(message.getPayload()));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        boolean validationSuccess = ObjectUtils.isEmpty((Object[])validationExceptions);
        if (!validationSuccess) {
            String exceptionMessage = "Message was rejected due to XML Validation errors";
            if (this.throwExceptionOnRejection) {
                throw new MessageRejectedException(message, exceptionMessage, (Throwable)new AggregatedXmlMessageValidationException(Arrays.asList(validationExceptions)));
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Throwable)new AggregatedXmlMessageValidationException(Arrays.asList(validationExceptions)), (CharSequence)exceptionMessage);
            }
        }
        return validationSuccess;
    }

    public static enum SchemaType {
        XML_SCHEMA("http://www.w3.org/2001/XMLSchema"),
        RELAX_NG("http://relaxng.org/ns/structure/1.0");

        private final String url;

        private SchemaType(String url) {
            this.url = url;
        }

        public String getUrl() {
            return this.url;
        }
    }
}

